% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_schedule_key_deletion}
\alias{kms_schedule_key_deletion}
\title{Schedules the deletion of a customer master key (CMK)}
\usage{
kms_schedule_key_deletion(KeyId, PendingWindowInDays)
}
\arguments{
\item{KeyId}{[required] The unique identifier of the customer master key (CMK) to delete.

Specify the key ID or the Amazon Resource Name (ARN) of the CMK.

For example:
\itemize{
\item Key ID: \code{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\code{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}

\item{PendingWindowInDays}{The waiting period, specified in number of days. After the waiting
period ends, AWS KMS deletes the customer master key (CMK).

This value is optional. If you include a value, it must be between 7 and
30, inclusive. If you do not include a value, it defaults to 30.}
}
\description{
Schedules the deletion of a customer master key (CMK). You may provide a
waiting period, specified in days, before deletion occurs. If you do not
provide a waiting period, the default period of 30 days is used. When
this operation is successful, the key state of the CMK changes to
\code{PendingDeletion}. Before the waiting period ends, you can use
CancelKeyDeletion to cancel the deletion of the CMK. After the waiting
period ends, AWS KMS deletes the CMK and all AWS KMS data associated
with it, including all aliases that refer to it.
}
\details{
Deleting a CMK is a destructive and potentially dangerous operation.
When a CMK is deleted, all data that was encrypted under the CMK is
unrecoverable. To prevent the use of a CMK without deleting it, use
DisableKey.

If you schedule deletion of a CMK from a \href{https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html}{custom key store},
when the waiting period expires, \code{ScheduleKeyDeletion} deletes the CMK
from AWS KMS. Then AWS KMS makes a best effort to delete the key
material from the associated AWS CloudHSM cluster. However, you might
need to manually \href{https://docs.aws.amazon.com/kms/latest/developerguide/fix-keystore.html#fix-keystore-orphaned-key}{delete the orphaned key material}
from the cluster and its backups.

You cannot perform this operation on a CMK in a different AWS account.

For more information about scheduling a CMK for deletion, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/deleting-keys.html}{Deleting Customer Master Keys}
in the \emph{AWS Key Management Service Developer Guide}.

The result of this operation varies with the key state of the CMK. For
details, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-state.html}{How Key State Affects Use of a Customer Master Key}
in the \emph{AWS Key Management Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$schedule_key_deletion(
  KeyId = "string",
  PendingWindowInDays = 123
)
}
}

\examples{
# The following example schedules the specified CMK for deletion.
\donttest{svc$schedule_key_deletion(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
  PendingWindowInDays = 7L
)}

}
\keyword{internal}
