% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_respond_to_auth_challenge}
\alias{cognitoidentityprovider_admin_respond_to_auth_challenge}
\title{Responds to an authentication challenge, as an administrator}
\usage{
cognitoidentityprovider_admin_respond_to_auth_challenge(UserPoolId,
  ClientId, ChallengeName, ChallengeResponses, Session, AnalyticsMetadata,
  ContextData)
}
\arguments{
\item{UserPoolId}{[required] The ID of the Amazon Cognito user pool.}

\item{ClientId}{[required] The app client ID.}

\item{ChallengeName}{[required] The challenge name. For more information, see .}

\item{ChallengeResponses}{The challenge responses. These are inputs corresponding to the value of
\code{ChallengeName}, for example:
\itemize{
\item \code{SMS_MFA}: \code{SMS_MFA_CODE}, \code{USERNAME}, \code{SECRET_HASH} (if app client
is configured with client secret).
\item \code{PASSWORD_VERIFIER}: \code{PASSWORD_CLAIM_SIGNATURE},
\code{PASSWORD_CLAIM_SECRET_BLOCK}, \code{TIMESTAMP}, \code{USERNAME},
\code{SECRET_HASH} (if app client is configured with client secret).
\item \code{ADMIN_NO_SRP_AUTH}: \code{PASSWORD}, \code{USERNAME}, \code{SECRET_HASH} (if app
client is configured with client secret).
\item \code{NEW_PASSWORD_REQUIRED}: \code{NEW_PASSWORD}, any other required
attributes, \code{USERNAME}, \code{SECRET_HASH} (if app client is configured
with client secret).
}

The value of the \code{USERNAME} attribute must be the user's actual
username, not an alias (such as email address or phone number). To make
this easier, the \code{AdminInitiateAuth} response includes the actual
username value in the \code{USERNAMEUSER_ID_FOR_SRP} attribute, even if you
specified an alias in your call to \code{AdminInitiateAuth}.}

\item{Session}{The session which should be passed both ways in challenge-response calls
to the service. If \code{InitiateAuth} or \code{RespondToAuthChallenge} API call
determines that the caller needs to go through another challenge, they
return a session with other challenge parameters. This session should be
passed as it is to the next \code{RespondToAuthChallenge} API call.}

\item{AnalyticsMetadata}{The analytics metadata for collecting Amazon Pinpoint metrics for
\code{AdminRespondToAuthChallenge} calls.}

\item{ContextData}{Contextual data such as the user's device fingerprint, IP address, or
location used for evaluating the risk of an unexpected event by Amazon
Cognito advanced security.}
}
\description{
Responds to an authentication challenge, as an administrator.
}
\details{
Requires developer credentials.
}
\section{Request syntax}{
\preformatted{svc$admin_respond_to_auth_challenge(
  UserPoolId = "string",
  ClientId = "string",
  ChallengeName = "SMS_MFA"|"SOFTWARE_TOKEN_MFA"|"SELECT_MFA_TYPE"|"MFA_SETUP"|"PASSWORD_VERIFIER"|"CUSTOM_CHALLENGE"|"DEVICE_SRP_AUTH"|"DEVICE_PASSWORD_VERIFIER"|"ADMIN_NO_SRP_AUTH"|"NEW_PASSWORD_REQUIRED",
  ChallengeResponses = list(
    "string"
  ),
  Session = "string",
  AnalyticsMetadata = list(
    AnalyticsEndpointId = "string"
  ),
  ContextData = list(
    IpAddress = "string",
    ServerName = "string",
    ServerPath = "string",
    HttpHeaders = list(
      list(
        headerName = "string",
        headerValue = "string"
      )
    ),
    EncodedData = "string"
  )
)
}
}

\keyword{internal}
