% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_create_geo_match_set}
\alias{waf_create_geo_match_set}
\title{This is AWS WAF Classic documentation}
\usage{
waf_create_geo_match_set(Name, ChangeToken)
}
\arguments{
\item{Name}{[required] A friendly name or description of the GeoMatchSet. You can't change
\code{Name} after you create the \code{GeoMatchSet}.}

\item{ChangeToken}{[required] The value returned by the most recent call to
\code{\link[=waf_get_change_token]{get_change_token}}.}
}
\value{
A list with the following syntax:\preformatted{list(
  GeoMatchSet = list(
    GeoMatchSetId = "string",
    Name = "string",
    GeoMatchConstraints = list(
      list(
        Type = "Country",
        Value = "AF"|"AX"|"AL"|"DZ"|"AS"|"AD"|"AO"|"AI"|"AQ"|"AG"|"AR"|"AM"|"AW"|"AU"|"AT"|"AZ"|"BS"|"BH"|"BD"|"BB"|"BY"|"BE"|"BZ"|"BJ"|"BM"|"BT"|"BO"|"BQ"|"BA"|"BW"|"BV"|"BR"|"IO"|"BN"|"BG"|"BF"|"BI"|"KH"|"CM"|"CA"|"CV"|"KY"|"CF"|"TD"|"CL"|"CN"|"CX"|"CC"|"CO"|"KM"|"CG"|"CD"|"CK"|"CR"|"CI"|"HR"|"CU"|"CW"|"CY"|"CZ"|"DK"|"DJ"|"DM"|"DO"|"EC"|"EG"|"SV"|"GQ"|"ER"|"EE"|"ET"|"FK"|"FO"|"FJ"|"FI"|"FR"|"GF"|"PF"|"TF"|"GA"|"GM"|"GE"|"DE"|"GH"|"GI"|"GR"|"GL"|"GD"|"GP"|"GU"|"GT"|"GG"|"GN"|"GW"|"GY"|"HT"|"HM"|"VA"|"HN"|"HK"|"HU"|"IS"|"IN"|"ID"|"IR"|"IQ"|"IE"|"IM"|"IL"|"IT"|"JM"|"JP"|"JE"|"JO"|"KZ"|"KE"|"KI"|"KP"|"KR"|"KW"|"KG"|"LA"|"LV"|"LB"|"LS"|"LR"|"LY"|"LI"|"LT"|"LU"|"MO"|"MK"|"MG"|"MW"|"MY"|"MV"|"ML"|"MT"|"MH"|"MQ"|"MR"|"MU"|"YT"|"MX"|"FM"|"MD"|"MC"|"MN"|"ME"|"MS"|"MA"|"MZ"|"MM"|"NA"|"NR"|"NP"|"NL"|"NC"|"NZ"|"NI"|"NE"|"NG"|"NU"|"NF"|"MP"|"NO"|"OM"|"PK"|"PW"|"PS"|"PA"|"PG"|"PY"|"PE"|"PH"|"PN"|"PL"|"PT"|"PR"|"QA"|"RE"|"RO"|"RU"|"RW"|"BL"|"SH"|"KN"|"LC"|"MF"|"PM"|"VC"|"WS"|"SM"|"ST"|"SA"|"SN"|"RS"|"SC"|"SL"|"SG"|"SX"|"SK"|"SI"|"SB"|"SO"|"ZA"|"GS"|"SS"|"ES"|"LK"|"SD"|"SR"|"SJ"|"SZ"|"SE"|"CH"|"SY"|"TW"|"TJ"|"TZ"|"TH"|"TL"|"TG"|"TK"|"TO"|"TT"|"TN"|"TR"|"TM"|"TC"|"TV"|"UG"|"UA"|"AE"|"GB"|"US"|"UM"|"UY"|"UZ"|"VU"|"VE"|"VN"|"VG"|"VI"|"WF"|"EH"|"YE"|"ZM"|"ZW"
      )
    )
  ),
  ChangeToken = "string"
)
}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.

\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Creates an GeoMatchSet, which you use to specify which web requests you
want to allow or block based on the country that the requests originate
from. For example, if you're receiving a lot of requests from one or
more countries and you want to block the requests, you can create an
\code{GeoMatchSet} that contains those countries and then configure AWS WAF
to block the requests.

To create and configure a \code{GeoMatchSet}, perform the following steps:
\enumerate{
\item Use \code{\link[=waf_get_change_token]{get_change_token}} to get the change
token that you provide in the \code{ChangeToken} parameter of a
\code{\link[=waf_create_geo_match_set]{create_geo_match_set}} request.
\item Submit a \code{\link[=waf_create_geo_match_set]{create_geo_match_set}} request.
\item Use \code{\link[=waf_get_change_token]{get_change_token}} to get the change
token that you provide in the \code{ChangeToken} parameter of an
\code{\link[=waf_update_geo_match_set]{update_geo_match_set}} request.
\item Submit an \code{UpdateGeoMatchSetSet} request to specify the countries
that you want AWS WAF to watch for.
}

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_geo_match_set(
  Name = "string",
  ChangeToken = "string"
)
}
}

\keyword{internal}
