% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudhsmv2_operations.R
\name{cloudhsmv2_delete_backup}
\alias{cloudhsmv2_delete_backup}
\title{Deletes a specified AWS CloudHSM backup}
\usage{
cloudhsmv2_delete_backup(BackupId)
}
\arguments{
\item{BackupId}{[required] The ID of the backup to be deleted. To find the ID of a backup, use the
\code{\link[=cloudhsmv2_describe_backups]{describe_backups}} operation.}
}
\value{
A list with the following syntax:\preformatted{list(
  Backup = list(
    BackupId = "string",
    BackupState = "CREATE_IN_PROGRESS"|"READY"|"DELETED"|"PENDING_DELETION",
    ClusterId = "string",
    CreateTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    CopyTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    NeverExpires = TRUE|FALSE,
    SourceRegion = "string",
    SourceBackup = "string",
    SourceCluster = "string",
    DeleteTimestamp = as.POSIXct(
      "2015-01-01"
    ),
    TagList = list(
      list(
        Key = "string",
        Value = "string"
      )
    )
  )
)
}
}
\description{
Deletes a specified AWS CloudHSM backup. A backup can be restored up to
7 days after the DeleteBackup request is made. For more information on
restoring a backup, see \code{\link[=cloudhsmv2_restore_backup]{restore_backup}}.
}
\section{Request syntax}{
\preformatted{svc$delete_backup(
  BackupId = "string"
)
}
}

\keyword{internal}
