% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fms_operations.R
\name{fms_get_violation_details}
\alias{fms_get_violation_details}
\title{Retrieves violations for a resource based on the specified AWS Firewall
Manager policy and AWS account}
\usage{
fms_get_violation_details(PolicyId, MemberAccount, ResourceId,
  ResourceType)
}
\arguments{
\item{PolicyId}{[required] The ID of the AWS Firewall Manager policy that you want the details for.
This currently only supports security group content audit policies.}

\item{MemberAccount}{[required] The AWS account ID that you want the details for.}

\item{ResourceId}{[required] The ID of the resource that has violations.}

\item{ResourceType}{[required] The resource type. This is in the format shown in the \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html}{AWS Resource Types Reference}.
Supported resource types are: \verb{AWS::EC2::Instance},
\verb{AWS::EC2::NetworkInterface}, \verb{AWS::EC2::SecurityGroup},
\verb{AWS::NetworkFirewall::FirewallPolicy}, and \verb{AWS::EC2::Subnet}.}
}
\description{
Retrieves violations for a resource based on the specified AWS Firewall
Manager policy and AWS account.
}
\section{Request syntax}{
\preformatted{svc$get_violation_details(
  PolicyId = "string",
  MemberAccount = "string",
  ResourceId = "string",
  ResourceType = "string"
)
}
}

\keyword{internal}
