% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_update_web_acl}
\alias{wafregional_update_web_acl}
\title{Inserts or deletes ActivatedRule objects in a WebACL}
\usage{
wafregional_update_web_acl(WebACLId, ChangeToken, Updates,
  DefaultAction)
}
\arguments{
\item{WebACLId}{[required] The \code{WebACLId} of the WebACL that you want to update. \code{WebACLId} is
returned by CreateWebACL and by ListWebACLs.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}

\item{Updates}{An array of updates to make to the WebACL.

An array of \code{WebACLUpdate} objects that you want to insert into or
delete from a WebACL. For more information, see the applicable data
types:
\itemize{
\item WebACLUpdate: Contains \code{Action} and \code{ActivatedRule}
\item ActivatedRule: Contains \code{Action}, \code{OverrideAction}, \code{Priority},
\code{RuleId}, and \code{Type}. \code{ActivatedRule|OverrideAction} applies only
when updating or adding a \code{RuleGroup} to a \code{WebACL}. In this case,
you do not use \code{ActivatedRule|Action}. For all other update
requests, \code{ActivatedRule|Action} is used instead of
\code{ActivatedRule|OverrideAction}.
\item WafAction: Contains \code{Type}
}}

\item{DefaultAction}{A default action for the web ACL, either ALLOW or BLOCK. AWS WAF
performs the default action if a request doesn't match the criteria in
any of the rules in a web ACL.}
}
\description{
Inserts or deletes ActivatedRule objects in a \code{WebACL}. Each \code{Rule}
identifies web requests that you want to allow, block, or count. When
you update a \code{WebACL}, you specify the following values:
}
\details{
\itemize{
\item A default action for the \code{WebACL}, either \code{ALLOW} or \code{BLOCK}. AWS
WAF performs the default action if a request doesn't match the
criteria in any of the \code{Rules} in a \code{WebACL}.
\item The \code{Rules} that you want to add or delete. If you want to replace
one \code{Rule} with another, you delete the existing \code{Rule} and add the
new one.
\item For each \code{Rule}, whether you want AWS WAF to allow requests, block
requests, or count requests that match the conditions in the \code{Rule}.
\item The order in which you want AWS WAF to evaluate the \code{Rules} in a
\code{WebACL}. If you add more than one \code{Rule} to a \code{WebACL}, AWS WAF
evaluates each request against the \code{Rules} in order based on the
value of \code{Priority}. (The \code{Rule} that has the lowest value for
\code{Priority} is evaluated first.) When a web request matches all the
predicates (such as \code{ByteMatchSets} and \code{IPSets}) in a \code{Rule}, AWS
WAF immediately takes the corresponding action, allow or block, and
doesn't evaluate the request against the remaining \code{Rules} in the
\code{WebACL}, if any.
}

To create and configure a \code{WebACL}, perform the following steps:
\enumerate{
\item Create and update the predicates that you want to include in
\code{Rules}. For more information, see CreateByteMatchSet,
UpdateByteMatchSet, CreateIPSet, UpdateIPSet,
CreateSqlInjectionMatchSet, and UpdateSqlInjectionMatchSet.
\item Create and update the \code{Rules} that you want to include in the
\code{WebACL}. For more information, see CreateRule and UpdateRule.
\item Create a \code{WebACL}. See CreateWebACL.
\item Use \code{GetChangeToken} to get the change token that you provide in the
\code{ChangeToken} parameter of an UpdateWebACL request.
\item Submit an \code{UpdateWebACL} request to specify the \code{Rules} that you
want to include in the \code{WebACL}, to specify the default action, and
to associate the \code{WebACL} with a CloudFront distribution.
}

The \code{ActivatedRule} can be a rule group. If you specify a rule group
as your \code{ActivatedRule}, you can exclude specific rules from that
rule group.

If you already have a rule group associated with a web ACL and want
to submit an \code{UpdateWebACL} request to exclude certain rules from
that rule group, you must first remove the rule group from the web
ACL, the re-insert it again, specifying the excluded rules. For
details, see ActivatedRule\$ExcludedRules.

Be aware that if you try to add a RATE\_BASED rule to a web ACL without
setting the rule type when first creating the rule, the UpdateWebACL
request will fail because the request tries to add a REGULAR rule (the
default rule type) with the specified ID, which does not exist.

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_web_acl(
  WebACLId = "string",
  ChangeToken = "string",
  Updates = list(
    list(
      Action = "INSERT"|"DELETE",
      ActivatedRule = list(
        Priority = 123,
        RuleId = "string",
        Action = list(
          Type = "BLOCK"|"ALLOW"|"COUNT"
        ),
        OverrideAction = list(
          Type = "NONE"|"COUNT"
        ),
        Type = "REGULAR"|"RATE_BASED"|"GROUP",
        ExcludedRules = list(
          list(
            RuleId = "string"
          )
        )
      )
    )
  ),
  DefaultAction = list(
    Type = "BLOCK"|"ALLOW"|"COUNT"
  )
)
}
}

\examples{
# The following example deletes an ActivatedRule object in a WebACL with
# the ID webacl-1472061481310.
\donttest{svc$update_web_acl(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  DefaultAction = list(
    Type = "ALLOW"
  ),
  Updates = list(
    list(
      Action = "DELETE",
      ActivatedRule = list(
        Action = list(
          Type = "ALLOW"
        ),
        Priority = 1L,
        RuleId = "WAFRule-1-Example"
      )
    )
  ),
  WebACLId = "webacl-1472061481310"
)}

}
\keyword{internal}
