% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/securityhub_operations.R
\name{securityhub_update_findings}
\alias{securityhub_update_findings}
\title{Updates the AWS Security Hub-aggregated findings specified by the filter
attributes}
\usage{
securityhub_update_findings(Filters, Note, RecordState)
}
\arguments{
\item{Filters}{[required] A collection of attributes that specify what findings you want to
update.}

\item{Note}{The updated note for the finding.}

\item{RecordState}{The updated record state for the finding.}
}
\description{
Updates the AWS Security Hub-aggregated findings specified by the filter
attributes.
}
\section{Request syntax}{
\preformatted{svc$update_findings(
  Filters = list(
    ProductArn = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    AwsAccountId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    Id = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    GeneratorId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    Type = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    FirstObservedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    LastObservedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    CreatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    UpdatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    SeverityProduct = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    SeverityNormalized = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    SeverityLabel = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    Confidence = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    Criticality = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    Title = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    Description = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    RecommendationText = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    SourceUrl = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ProductFields = list(
      list(
        Key = "string",
        Value = "string",
        Comparison = "CONTAINS"
      )
    ),
    ProductName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    CompanyName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    UserDefinedFields = list(
      list(
        Key = "string",
        Value = "string",
        Comparison = "CONTAINS"
      )
    ),
    MalwareName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    MalwareType = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    MalwarePath = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    MalwareState = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    NetworkDirection = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    NetworkProtocol = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    NetworkSourceIpV4 = list(
      list(
        Cidr = "string"
      )
    ),
    NetworkSourceIpV6 = list(
      list(
        Cidr = "string"
      )
    ),
    NetworkSourcePort = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    NetworkSourceDomain = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    NetworkSourceMac = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    NetworkDestinationIpV4 = list(
      list(
        Cidr = "string"
      )
    ),
    NetworkDestinationIpV6 = list(
      list(
        Cidr = "string"
      )
    ),
    NetworkDestinationPort = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    NetworkDestinationDomain = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ProcessName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ProcessPath = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ProcessPid = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    ProcessParentPid = list(
      list(
        Gte = 123.0,
        Lte = 123.0,
        Eq = 123.0
      )
    ),
    ProcessLaunchedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ProcessTerminatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ThreatIntelIndicatorType = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ThreatIntelIndicatorValue = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ThreatIntelIndicatorCategory = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ThreatIntelIndicatorLastObservedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ThreatIntelIndicatorSource = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ThreatIntelIndicatorSourceUrl = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ResourceType = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ResourceId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ResourcePartition = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ResourceRegion = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ResourceTags = list(
      list(
        Key = "string",
        Value = "string",
        Comparison = "CONTAINS"
      )
    ),
    ResourceAwsEc2InstanceType = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ResourceAwsEc2InstanceImageId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ResourceAwsEc2InstanceIpV4Addresses = list(
      list(
        Cidr = "string"
      )
    ),
    ResourceAwsEc2InstanceIpV6Addresses = list(
      list(
        Cidr = "string"
      )
    ),
    ResourceAwsEc2InstanceKeyName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ResourceAwsEc2InstanceIamInstanceProfileArn = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ResourceAwsEc2InstanceVpcId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ResourceAwsEc2InstanceSubnetId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ResourceAwsEc2InstanceLaunchedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ResourceAwsS3BucketOwnerId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ResourceAwsS3BucketOwnerName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ResourceAwsIamAccessKeyUserName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ResourceAwsIamAccessKeyStatus = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ResourceAwsIamAccessKeyCreatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ResourceContainerName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ResourceContainerImageId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ResourceContainerImageName = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    ResourceContainerLaunchedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    ResourceDetailsOther = list(
      list(
        Key = "string",
        Value = "string",
        Comparison = "CONTAINS"
      )
    ),
    ComplianceStatus = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    VerificationState = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    WorkflowState = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    RecordState = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    RelatedFindingsProductArn = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    RelatedFindingsId = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    NoteText = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    NoteUpdatedAt = list(
      list(
        Start = "string",
        End = "string",
        DateRange = list(
          Value = 123,
          Unit = "DAYS"
        )
      )
    ),
    NoteUpdatedBy = list(
      list(
        Value = "string",
        Comparison = "EQUALS"|"CONTAINS"|"PREFIX"
      )
    ),
    Keyword = list(
      list(
        Value = "string"
      )
    )
  ),
  Note = list(
    Text = "string",
    UpdatedBy = "string"
  ),
  RecordState = "ACTIVE"|"ARCHIVED"
)
}
}

\keyword{internal}
