% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_list_members}
\alias{guardduty_list_members}
\title{Lists details about all member accounts for the current GuardDuty master
account}
\usage{
guardduty_list_members(DetectorId, MaxResults, NextToken,
  OnlyAssociated)
}
\arguments{
\item{DetectorId}{[required] The unique ID of the detector of the GuardDuty account whose members you want to list.}

\item{MaxResults}{You can use this parameter to indicate the maximum number of items you want in the response. The default value is 1. The maximum value is 50.}

\item{NextToken}{You can use this parameter when paginating results. Set the value of this parameter to null on your first call to the ListMembers action. Subsequent calls to the action fill nextToken in the request with the value of NextToken from the previous response to continue listing data.}

\item{OnlyAssociated}{Specifies what member accounts the response is to include based on their relationship status with the master account. The default value is TRUE. If onlyAssociated is set to TRUE, the response will include member accounts whose relationship status with the master is set to Enabled, Disabled. If onlyAssociated is set to FALSE, the response will include all existing member accounts.}
}
\description{
Lists details about all member accounts for the current GuardDuty master account.
}
\section{Request syntax}{
\preformatted{svc$list_members(
  DetectorId = "string",
  MaxResults = 123,
  NextToken = "string",
  OnlyAssociated = "string"
)
}
}

\keyword{internal}
