% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicediscovery_operations.R
\name{servicediscovery_get_instances_health_status}
\alias{servicediscovery_get_instances_health_status}
\title{Gets the current health status (Healthy, Unhealthy, or Unknown) of one
or more instances that are associated with a specified service}
\usage{
servicediscovery_get_instances_health_status(
  ServiceId,
  Instances = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{ServiceId}{[required] The ID of the service that the instance is associated with.}

\item{Instances}{An array that contains the IDs of all the instances that you want to get
the health status for.

If you omit \code{Instances}, Cloud Map returns the health status for all the
instances that are associated with the specified service.

To get the IDs for the instances that you've registered by using a
specified service, submit a
\code{\link[=servicediscovery_list_instances]{list_instances}} request.}

\item{MaxResults}{The maximum number of instances that you want Cloud Map to return in the
response to a
\code{\link[=servicediscovery_get_instances_health_status]{get_instances_health_status}}
request. If you don't specify a value for \code{MaxResults}, Cloud Map
returns up to 100 instances.}

\item{NextToken}{For the first
\code{\link[=servicediscovery_get_instances_health_status]{get_instances_health_status}}
request, omit this value.

If more than \code{MaxResults} instances match the specified criteria, you
can submit another
\code{\link[=servicediscovery_get_instances_health_status]{get_instances_health_status}}
request to get the next group of results. Specify the value of
\code{NextToken} from the previous response in the next request.}
}
\description{
Gets the current health status (\code{Healthy}, \code{Unhealthy}, or \code{Unknown}) of one or more instances that are associated with a specified service.

See \url{https://www.paws-r-sdk.com/docs/servicediscovery_get_instances_health_status/} for full documentation.
}
\keyword{internal}
