% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigatewayv2_operations.R
\name{apigatewayv2_update_route}
\alias{apigatewayv2_update_route}
\title{Updates a Route}
\usage{
apigatewayv2_update_route(
  ApiId,
  ApiKeyRequired = NULL,
  AuthorizationScopes = NULL,
  AuthorizationType = NULL,
  AuthorizerId = NULL,
  ModelSelectionExpression = NULL,
  OperationName = NULL,
  RequestModels = NULL,
  RequestParameters = NULL,
  RouteId,
  RouteKey = NULL,
  RouteResponseSelectionExpression = NULL,
  Target = NULL
)
}
\arguments{
\item{ApiId}{[required] The API identifier.}

\item{ApiKeyRequired}{Specifies whether an API key is required for the route. Supported only
for WebSocket APIs.}

\item{AuthorizationScopes}{The authorization scopes supported by this route.}

\item{AuthorizationType}{The authorization type for the route. For WebSocket APIs, valid values
are NONE for open access, AWS_IAM for using AWS IAM permissions, and
CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are
NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using
AWS IAM permissions, and CUSTOM for using a Lambda authorizer.}

\item{AuthorizerId}{The identifier of the Authorizer resource to be associated with this
route. The authorizer identifier is generated by API Gateway when you
created the authorizer.}

\item{ModelSelectionExpression}{The model selection expression for the route. Supported only for
WebSocket APIs.}

\item{OperationName}{The operation name for the route.}

\item{RequestModels}{The request models for the route. Supported only for WebSocket APIs.}

\item{RequestParameters}{The request parameters for the route. Supported only for WebSocket APIs.}

\item{RouteId}{[required] The route ID.}

\item{RouteKey}{The route key for the route.}

\item{RouteResponseSelectionExpression}{The route response selection expression for the route. Supported only
for WebSocket APIs.}

\item{Target}{The target for the route.}
}
\description{
Updates a Route.

See \url{https://www.paws-r-sdk.com/docs/apigatewayv2_update_route/} for full documentation.
}
\keyword{internal}
