% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicediscovery_operations.R
\name{servicediscovery_create_public_dns_namespace}
\alias{servicediscovery_create_public_dns_namespace}
\title{Creates a public namespace based on DNS, which is visible on the
internet}
\usage{
servicediscovery_create_public_dns_namespace(
  Name,
  CreatorRequestId = NULL,
  Description = NULL,
  Tags = NULL,
  Properties = NULL
)
}
\arguments{
\item{Name}{[required] The name that you want to assign to this namespace.}

\item{CreatorRequestId}{A unique string that identifies the request and that allows failed
\code{\link[=servicediscovery_create_public_dns_namespace]{create_public_dns_namespace}}
requests to be retried without the risk of running the operation twice.
\code{CreatorRequestId} can be any unique string (for example, a
date/timestamp).}

\item{Description}{A description for the namespace.}

\item{Tags}{The tags to add to the namespace. Each tag consists of a key and an
optional value that you define. Tags keys can be up to 128 characters in
length, and tag values can be up to 256 characters in length.}

\item{Properties}{Properties for the public DNS namespace.}
}
\description{
Creates a public namespace based on DNS, which is visible on the internet. The namespace defines your service naming scheme. For example, if you name your namespace \code{example.com} and name your service \code{backend}, the resulting DNS name for the service is \code{backend.example.com}. You can discover instances that were registered with a public DNS namespace by using either a \code{\link[=servicediscovery_discover_instances]{discover_instances}} request or using DNS. For the current quota on the number of namespaces that you can create using the same account, see \href{https://docs.aws.amazon.com/cloud-map/latest/dg/cloud-map-limits.html}{Cloud Map quotas} in the \emph{Cloud Map Developer Guide}.

See \url{https://paws-r.github.io/docs/servicediscovery/create_public_dns_namespace.html} for full documentation.
}
\keyword{internal}
