% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53recoverycluster_operations.R
\name{route53recoverycluster_update_routing_control_states}
\alias{route53recoverycluster_update_routing_control_states}
\title{Set multiple routing control states}
\usage{
route53recoverycluster_update_routing_control_states(
  UpdateRoutingControlStateEntries,
  SafetyRulesToOverride = NULL
)
}
\arguments{
\item{UpdateRoutingControlStateEntries}{[required] A set of routing control entries that you want to update.}

\item{SafetyRulesToOverride}{The Amazon Resource Names (ARNs) for the safety rules that you want to
override when you're updating routing control states. You can override
one safety rule or multiple safety rules by including one or more ARNs,
separated by commas.

For more information, see \href{https://docs.aws.amazon.com/r53recovery/latest/dg/routing-control.override-safety-rule.html}{Override safety rules to reroute traffic}
in the Amazon Route 53 Application Recovery Controller Developer Guide.}
}
\description{
Set multiple routing control states. You can set the value for each state to be On or Off. When the state is On, traffic flows to a cell. When it's Off, traffic does not flow.

See \url{https://paws-r.github.io/docs/route53recoverycluster/update_routing_control_states.html} for full documentation.
}
\keyword{internal}
