% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elb_operations.R
\name{elb_create_load_balancer}
\alias{elb_create_load_balancer}
\title{Creates a Classic Load Balancer}
\usage{
elb_create_load_balancer(
  LoadBalancerName,
  Listeners,
  AvailabilityZones = NULL,
  Subnets = NULL,
  SecurityGroups = NULL,
  Scheme = NULL,
  Tags = NULL
)
}
\arguments{
\item{LoadBalancerName}{[required] The name of the load balancer.

This name must be unique within your set of load balancers for the
region, must have a maximum of 32 characters, must contain only
alphanumeric characters or hyphens, and cannot begin or end with a
hyphen.}

\item{Listeners}{[required] The listeners.

For more information, see \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html}{Listeners for Your Classic Load Balancer}
in the \emph{Classic Load Balancers Guide}.}

\item{AvailabilityZones}{One or more Availability Zones from the same region as the load
balancer.

You must specify at least one Availability Zone.

You can add more Availability Zones after you create the load balancer
using
\code{\link[=elb_enable_availability_zones_for_load_balancer]{enable_availability_zones_for_load_balancer}}.}

\item{Subnets}{The IDs of the subnets in your VPC to attach to the load balancer.
Specify one subnet per Availability Zone specified in
\code{AvailabilityZones}.}

\item{SecurityGroups}{The IDs of the security groups to assign to the load balancer.}

\item{Scheme}{The type of a load balancer. Valid only for load balancers in a VPC.

By default, Elastic Load Balancing creates an Internet-facing load
balancer with a DNS name that resolves to public IP addresses. For more
information about Internet-facing and Internal load balancers, see \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/how-elastic-load-balancing-works.html#load-balancer-scheme}{Load Balancer Scheme}
in the \emph{Elastic Load Balancing User Guide}.

Specify \code{internal} to create a load balancer with a DNS name that
resolves to private IP addresses.}

\item{Tags}{A list of tags to assign to the load balancer.

For more information about tagging your load balancer, see \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html}{Tag Your Classic Load Balancer}
in the \emph{Classic Load Balancers Guide}.}
}
\description{
Creates a Classic Load Balancer.

See \url{https://paws-r.github.io/docs/elb/create_load_balancer.html} for full documentation.
}
\keyword{internal}
