% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_allocate_hosted_connection}
\alias{directconnect_allocate_hosted_connection}
\title{Creates a hosted connection on the specified interconnect or a link
aggregation group (LAG) of interconnects}
\usage{
directconnect_allocate_hosted_connection(
  connectionId,
  ownerAccount,
  bandwidth,
  connectionName,
  vlan,
  tags = NULL
)
}
\arguments{
\item{connectionId}{[required] The ID of the interconnect or LAG.}

\item{ownerAccount}{[required] The ID of the Amazon Web Services account ID of the customer for the
connection.}

\item{bandwidth}{[required] The bandwidth of the connection. The possible values are 50Mbps,
100Mbps, 200Mbps, 300Mbps, 400Mbps, 500Mbps, 1Gbps, 2Gbps, 5Gbps, and
10Gbps. Note that only those Direct Connect Partners who have met
specific requirements are allowed to create a 1Gbps, 2Gbps, 5Gbps or
10Gbps hosted connection.}

\item{connectionName}{[required] The name of the hosted connection.}

\item{vlan}{[required] The dedicated VLAN provisioned to the hosted connection.}

\item{tags}{The tags associated with the connection.}
}
\description{
Creates a hosted connection on the specified interconnect or a link aggregation group (LAG) of interconnects.

See \url{https://paws-r.github.io/docs/directconnect/allocate_hosted_connection.html} for full documentation.
}
\keyword{internal}
