% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elb_operations.R
\name{elb_apply_security_groups_to_load_balancer}
\alias{elb_apply_security_groups_to_load_balancer}
\title{Associates one or more security groups with your load balancer in a
virtual private cloud (VPC)}
\usage{
elb_apply_security_groups_to_load_balancer(LoadBalancerName,
  SecurityGroups)
}
\arguments{
\item{LoadBalancerName}{[required] The name of the load balancer.}

\item{SecurityGroups}{[required] The IDs of the security groups to associate with the load balancer. Note
that you cannot specify the name of the security group.}
}
\description{
Associates one or more security groups with your load balancer in a
virtual private cloud (VPC). The specified security groups override the
previously associated security groups.
}
\details{
For more information, see \href{http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-security-groups.html#elb-vpc-security-groups}{Security Groups for Load Balancers in a VPC}
in the \emph{Classic Load Balancers Guide}.
}
\section{Request syntax}{
\preformatted{svc$apply_security_groups_to_load_balancer(
  LoadBalancerName = "string",
  SecurityGroups = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# This example associates a security group with the specified load
# balancer in a VPC.
svc$apply_security_groups_to_load_balancer(
  LoadBalancerName = "my-load-balancer",
  SecurityGroups = list(
    "sg-fc448899"
  )
)
}

}
\keyword{internal}
