% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigatewayv2_operations.R
\name{apigatewayv2_update_stage}
\alias{apigatewayv2_update_stage}
\title{Updates a Stage}
\usage{
apigatewayv2_update_stage(AccessLogSettings, ApiId, AutoDeploy,
  ClientCertificateId, DefaultRouteSettings, DeploymentId, Description,
  RouteSettings, StageName, StageVariables)
}
\arguments{
\item{AccessLogSettings}{Settings for logging access in this stage.}

\item{ApiId}{[required] The API identifier.}

\item{AutoDeploy}{Specifies whether updates to an API automatically trigger a new
deployment. The default value is false.}

\item{ClientCertificateId}{The identifier of a client certificate for a Stage.}

\item{DefaultRouteSettings}{The default route settings for the stage.}

\item{DeploymentId}{The deployment identifier for the API stage. Can't be updated if
autoDeploy is enabled.}

\item{Description}{The description for the API stage.}

\item{RouteSettings}{Route settings for the stage.}

\item{StageName}{[required] The stage name. Stage names can contain only alphanumeric characters,
hyphens, and underscores, or be $default. Maximum length is 128
characters.}

\item{StageVariables}{A map that defines the stage variables for a Stage. Variable names can
have alphanumeric and underscore characters, and the values must match
[A-Za-z0-9-._~:/?\#&=,]+.}
}
\value{
A list with the following syntax:\preformatted{list(
  AccessLogSettings = list(
    DestinationArn = "string",
    Format = "string"
  ),
  ApiGatewayManaged = TRUE|FALSE,
  AutoDeploy = TRUE|FALSE,
  ClientCertificateId = "string",
  CreatedDate = as.POSIXct(
    "2015-01-01"
  ),
  DefaultRouteSettings = list(
    DataTraceEnabled = TRUE|FALSE,
    DetailedMetricsEnabled = TRUE|FALSE,
    LoggingLevel = "ERROR"|"INFO"|"OFF",
    ThrottlingBurstLimit = 123,
    ThrottlingRateLimit = 123.0
  ),
  DeploymentId = "string",
  Description = "string",
  LastDeploymentStatusMessage = "string",
  LastUpdatedDate = as.POSIXct(
    "2015-01-01"
  ),
  RouteSettings = list(
    list(
      DataTraceEnabled = TRUE|FALSE,
      DetailedMetricsEnabled = TRUE|FALSE,
      LoggingLevel = "ERROR"|"INFO"|"OFF",
      ThrottlingBurstLimit = 123,
      ThrottlingRateLimit = 123.0
    )
  ),
  StageName = "string",
  StageVariables = list(
    "string"
  ),
  Tags = list(
    "string"
  )
)
}
}
\description{
Updates a Stage.
}
\section{Request syntax}{
\preformatted{svc$update_stage(
  AccessLogSettings = list(
    DestinationArn = "string",
    Format = "string"
  ),
  ApiId = "string",
  AutoDeploy = TRUE|FALSE,
  ClientCertificateId = "string",
  DefaultRouteSettings = list(
    DataTraceEnabled = TRUE|FALSE,
    DetailedMetricsEnabled = TRUE|FALSE,
    LoggingLevel = "ERROR"|"INFO"|"OFF",
    ThrottlingBurstLimit = 123,
    ThrottlingRateLimit = 123.0
  ),
  DeploymentId = "string",
  Description = "string",
  RouteSettings = list(
    list(
      DataTraceEnabled = TRUE|FALSE,
      DetailedMetricsEnabled = TRUE|FALSE,
      LoggingLevel = "ERROR"|"INFO"|"OFF",
      ThrottlingBurstLimit = 123,
      ThrottlingRateLimit = 123.0
    )
  ),
  StageName = "string",
  StageVariables = list(
    "string"
  )
)
}
}

\keyword{internal}
