% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicediscovery_operations.R
\name{servicediscovery_get_operation}
\alias{servicediscovery_get_operation}
\title{Gets information about any operation that returns an operation ID in the
response, such as a CreateService request}
\usage{
servicediscovery_get_operation(OperationId)
}
\arguments{
\item{OperationId}{[required] The ID of the operation that you want to get more information about.}
}
\value{
A list with the following syntax:\preformatted{list(
  Operation = list(
    Id = "string",
    Type = "CREATE_NAMESPACE"|"DELETE_NAMESPACE"|"UPDATE_SERVICE"|"REGISTER_INSTANCE"|"DEREGISTER_INSTANCE",
    Status = "SUBMITTED"|"PENDING"|"SUCCESS"|"FAIL",
    ErrorMessage = "string",
    ErrorCode = "string",
    CreateDate = as.POSIXct(
      "2015-01-01"
    ),
    UpdateDate = as.POSIXct(
      "2015-01-01"
    ),
    Targets = list(
      "string"
    )
  )
)
}
}
\description{
Gets information about any operation that returns an operation ID in the
response, such as a \code{\link[=servicediscovery_create_service]{create_service}}
request.

To get a list of operations that match specified criteria, see
\code{\link[=servicediscovery_list_operations]{list_operations}}.
}
\section{Request syntax}{
\preformatted{svc$get_operation(
  OperationId = "string"
)
}
}

\examples{
\dontrun{
# Example: Get operation result
svc$get_operation(
  OperationId = "gv4g5meo7ndmeh4fqskygvk23d2fijwa-k9302yzd"
)
}

}
\keyword{internal}
