% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalaccelerator_operations.R
\name{globalaccelerator_update_custom_routing_listener}
\alias{globalaccelerator_update_custom_routing_listener}
\title{Update a listener for a custom routing accelerator}
\usage{
globalaccelerator_update_custom_routing_listener(ListenerArn,
  PortRanges)
}
\arguments{
\item{ListenerArn}{[required] The Amazon Resource Name (ARN) of the listener to update.}

\item{PortRanges}{[required] The updated port range to support for connections from clients to your
accelerator. If you remove ports that are currently being used by a
subnet endpoint, the call fails.

Separately, you set port ranges for endpoints. For more information, see
\href{https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html}{About endpoints for custom routing accelerators}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Listener = list(
    ListenerArn = "string",
    PortRanges = list(
      list(
        FromPort = 123,
        ToPort = 123
      )
    )
  )
)
}
}
\description{
Update a listener for a custom routing accelerator.
}
\section{Request syntax}{
\preformatted{svc$update_custom_routing_listener(
  ListenerArn = "string",
  PortRanges = list(
    list(
      FromPort = 123,
      ToPort = 123
    )
  )
)
}
}

\keyword{internal}
