% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53domains_operations.R
\name{route53domains_list_operations}
\alias{route53domains_list_operations}
\title{Returns information about all of the operations that return an operation
ID and that have ever been performed on domains that were registered by
the current account}
\usage{
route53domains_list_operations(SubmittedSince, Marker, MaxItems)
}
\arguments{
\item{SubmittedSince}{An optional parameter that lets you get information about all the
operations that you submitted after a specified date and time. Specify
the date and time in Unix time format and Coordinated Universal time
(UTC).}

\item{Marker}{For an initial request for a list of operations, omit this element. If
the number of operations that are not yet complete is greater than the
value that you specified for \code{MaxItems}, you can use \code{Marker} to return
additional operations. Get the value of \code{NextPageMarker} from the
previous response, and submit another request that includes the value of
\code{NextPageMarker} in the \code{Marker} element.}

\item{MaxItems}{Number of domains to be returned.

Default: 20}
}
\value{
A list with the following syntax:\preformatted{list(
  Operations = list(
    list(
      OperationId = "string",
      Status = "SUBMITTED"|"IN_PROGRESS"|"ERROR"|"SUCCESSFUL"|"FAILED",
      Type = "REGISTER_DOMAIN"|"DELETE_DOMAIN"|"TRANSFER_IN_DOMAIN"|"UPDATE_DOMAIN_CONTACT"|"UPDATE_NAMESERVER"|"CHANGE_PRIVACY_PROTECTION"|"DOMAIN_LOCK"|"ENABLE_AUTORENEW"|"DISABLE_AUTORENEW"|"ADD_DNSSEC"|"REMOVE_DNSSEC"|"EXPIRE_DOMAIN"|"TRANSFER_OUT_DOMAIN"|"CHANGE_DOMAIN_OWNER"|"RENEW_DOMAIN"|"PUSH_DOMAIN"|"INTERNAL_TRANSFER_OUT_DOMAIN"|"INTERNAL_TRANSFER_IN_DOMAIN",
      SubmittedDate = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextPageMarker = "string"
)
}
}
\description{
Returns information about all of the operations that return an operation
ID and that have ever been performed on domains that were registered by
the current account.
}
\section{Request syntax}{
\preformatted{svc$list_operations(
  SubmittedSince = as.POSIXct(
    "2015-01-01"
  ),
  Marker = "string",
  MaxItems = 123
)
}
}

\keyword{internal}
