% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_start_import}
\alias{cloudtrail_start_import}
\title{Starts an import of logged trail events from a source S3 bucket to a
destination event data store}
\usage{
cloudtrail_start_import(
  Destinations = NULL,
  ImportSource = NULL,
  StartEventTime = NULL,
  EndEventTime = NULL,
  ImportId = NULL
)
}
\arguments{
\item{Destinations}{The ARN of the destination event data store. Use this parameter for a
new import.}

\item{ImportSource}{The source S3 bucket for the import. Use this parameter for a new
import.}

\item{StartEventTime}{Use with \code{EndEventTime} to bound a
\code{\link[=cloudtrail_start_import]{start_import}} request, and limit imported
trail events to only those events logged within a specified time period.
When you specify a time range, CloudTrail checks the prefix and log file
names to verify the names contain a date between the specified
\code{StartEventTime} and \code{EndEventTime} before attempting to import events.}

\item{EndEventTime}{Use with \code{StartEventTime} to bound a
\code{\link[=cloudtrail_start_import]{start_import}} request, and limit imported
trail events to only those events logged within a specified time period.
When you specify a time range, CloudTrail checks the prefix and log file
names to verify the names contain a date between the specified
\code{StartEventTime} and \code{EndEventTime} before attempting to import events.}

\item{ImportId}{The ID of the import. Use this parameter when you are retrying an
import.}
}
\description{
Starts an import of logged trail events from a source S3 bucket to a destination event data store. By default, CloudTrail only imports events contained in the S3 bucket's \code{CloudTrail} prefix and the prefixes inside the \code{CloudTrail} prefix, and does not check prefixes for other Amazon Web Services services. If you want to import CloudTrail events contained in another prefix, you must include the prefix in the \code{S3LocationUri}. For more considerations about importing trail events, see \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-copy-trail-to-lake.html#cloudtrail-trail-copy-considerations}{Considerations for copying trail events} in the \emph{CloudTrail User Guide}.

See \url{https://www.paws-r-sdk.com/docs/cloudtrail_start_import/} for full documentation.
}
\keyword{internal}
