# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Auto Scaling
#'
#' @description
#' Amazon EC2 Auto Scaling
#' 
#' Amazon EC2 Auto Scaling is designed to automatically launch and
#' terminate EC2 instances based on user-defined scaling policies,
#' scheduled actions, and health checks.
#' 
#' For more information, see the [Amazon EC2 Auto Scaling User
#' Guide](https://docs.aws.amazon.com/autoscaling/ec2/userguide/what-is-amazon-ec2-auto-scaling.html)
#' and the [Amazon EC2 Auto Scaling API
#' Reference](https://docs.aws.amazon.com/autoscaling/ec2/APIReference/Welcome.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- autoscaling(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- autoscaling()
#' # This example attaches the specified instance to the specified Auto
#' # Scaling group.
#' svc$attach_instances(
#'   AutoScalingGroupName = "my-auto-scaling-group",
#'   InstanceIds = list(
#'     "i-93633f9b"
#'   )
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=autoscaling_attach_instances]{attach_instances} \tab Attaches one or more EC2 instances to the specified Auto Scaling group\cr
#'  \link[=autoscaling_attach_load_balancers]{attach_load_balancers} \tab This API operation is superseded by https://docs\cr
#'  \link[=autoscaling_attach_load_balancer_target_groups]{attach_load_balancer_target_groups} \tab This API operation is superseded by AttachTrafficSources, which can attach multiple traffic sources types\cr
#'  \link[=autoscaling_attach_traffic_sources]{attach_traffic_sources} \tab Attaches one or more traffic sources to the specified Auto Scaling group\cr
#'  \link[=autoscaling_batch_delete_scheduled_action]{batch_delete_scheduled_action} \tab Deletes one or more scheduled actions for the specified Auto Scaling group\cr
#'  \link[=autoscaling_batch_put_scheduled_update_group_action]{batch_put_scheduled_update_group_action} \tab Creates or updates one or more scheduled scaling actions for an Auto Scaling group\cr
#'  \link[=autoscaling_cancel_instance_refresh]{cancel_instance_refresh} \tab Cancels an instance refresh or rollback that is in progress\cr
#'  \link[=autoscaling_complete_lifecycle_action]{complete_lifecycle_action} \tab Completes the lifecycle action for the specified token or instance with the specified result\cr
#'  \link[=autoscaling_create_auto_scaling_group]{create_auto_scaling_group} \tab We strongly recommend using a launch template when calling this operation to ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2\cr
#'  \link[=autoscaling_create_launch_configuration]{create_launch_configuration} \tab Creates a launch configuration\cr
#'  \link[=autoscaling_create_or_update_tags]{create_or_update_tags} \tab Creates or updates tags for the specified Auto Scaling group\cr
#'  \link[=autoscaling_delete_auto_scaling_group]{delete_auto_scaling_group} \tab Deletes the specified Auto Scaling group\cr
#'  \link[=autoscaling_delete_launch_configuration]{delete_launch_configuration} \tab Deletes the specified launch configuration\cr
#'  \link[=autoscaling_delete_lifecycle_hook]{delete_lifecycle_hook} \tab Deletes the specified lifecycle hook\cr
#'  \link[=autoscaling_delete_notification_configuration]{delete_notification_configuration} \tab Deletes the specified notification\cr
#'  \link[=autoscaling_delete_policy]{delete_policy} \tab Deletes the specified scaling policy\cr
#'  \link[=autoscaling_delete_scheduled_action]{delete_scheduled_action} \tab Deletes the specified scheduled action\cr
#'  \link[=autoscaling_delete_tags]{delete_tags} \tab Deletes the specified tags\cr
#'  \link[=autoscaling_delete_warm_pool]{delete_warm_pool} \tab Deletes the warm pool for the specified Auto Scaling group\cr
#'  \link[=autoscaling_describe_account_limits]{describe_account_limits} \tab Describes the current Amazon EC2 Auto Scaling resource quotas for your account\cr
#'  \link[=autoscaling_describe_adjustment_types]{describe_adjustment_types} \tab Describes the available adjustment types for step scaling and simple scaling policies\cr
#'  \link[=autoscaling_describe_auto_scaling_groups]{describe_auto_scaling_groups} \tab Gets information about the Auto Scaling groups in the account and Region\cr
#'  \link[=autoscaling_describe_auto_scaling_instances]{describe_auto_scaling_instances} \tab Gets information about the Auto Scaling instances in the account and Region\cr
#'  \link[=autoscaling_describe_auto_scaling_notification_types]{describe_auto_scaling_notification_types} \tab Describes the notification types that are supported by Amazon EC2 Auto Scaling\cr
#'  \link[=autoscaling_describe_instance_refreshes]{describe_instance_refreshes} \tab Gets information about the instance refreshes for the specified Auto Scaling group from the previous six weeks\cr
#'  \link[=autoscaling_describe_launch_configurations]{describe_launch_configurations} \tab Gets information about the launch configurations in the account and Region\cr
#'  \link[=autoscaling_describe_lifecycle_hooks]{describe_lifecycle_hooks} \tab Gets information about the lifecycle hooks for the specified Auto Scaling group\cr
#'  \link[=autoscaling_describe_lifecycle_hook_types]{describe_lifecycle_hook_types} \tab Describes the available types of lifecycle hooks\cr
#'  \link[=autoscaling_describe_load_balancers]{describe_load_balancers} \tab This API operation is superseded by DescribeTrafficSources, which can describe multiple traffic sources types\cr
#'  \link[=autoscaling_describe_load_balancer_target_groups]{describe_load_balancer_target_groups} \tab This API operation is superseded by DescribeTrafficSources, which can describe multiple traffic sources types\cr
#'  \link[=autoscaling_describe_metric_collection_types]{describe_metric_collection_types} \tab Describes the available CloudWatch metrics for Amazon EC2 Auto Scaling\cr
#'  \link[=autoscaling_describe_notification_configurations]{describe_notification_configurations} \tab Gets information about the Amazon SNS notifications that are configured for one or more Auto Scaling groups\cr
#'  \link[=autoscaling_describe_policies]{describe_policies} \tab Gets information about the scaling policies in the account and Region\cr
#'  \link[=autoscaling_describe_scaling_activities]{describe_scaling_activities} \tab Gets information about the scaling activities in the account and Region\cr
#'  \link[=autoscaling_describe_scaling_process_types]{describe_scaling_process_types} \tab Describes the scaling process types for use with the ResumeProcesses and SuspendProcesses APIs\cr
#'  \link[=autoscaling_describe_scheduled_actions]{describe_scheduled_actions} \tab Gets information about the scheduled actions that haven't run or that have not reached their end time\cr
#'  \link[=autoscaling_describe_tags]{describe_tags} \tab Describes the specified tags\cr
#'  \link[=autoscaling_describe_termination_policy_types]{describe_termination_policy_types} \tab Describes the termination policies supported by Amazon EC2 Auto Scaling\cr
#'  \link[=autoscaling_describe_traffic_sources]{describe_traffic_sources} \tab Gets information about the traffic sources for the specified Auto Scaling group\cr
#'  \link[=autoscaling_describe_warm_pool]{describe_warm_pool} \tab Gets information about a warm pool and its instances\cr
#'  \link[=autoscaling_detach_instances]{detach_instances} \tab Removes one or more instances from the specified Auto Scaling group\cr
#'  \link[=autoscaling_detach_load_balancers]{detach_load_balancers} \tab This API operation is superseded by DetachTrafficSources, which can detach multiple traffic sources types\cr
#'  \link[=autoscaling_detach_load_balancer_target_groups]{detach_load_balancer_target_groups} \tab This API operation is superseded by DetachTrafficSources, which can detach multiple traffic sources types\cr
#'  \link[=autoscaling_detach_traffic_sources]{detach_traffic_sources} \tab Detaches one or more traffic sources from the specified Auto Scaling group\cr
#'  \link[=autoscaling_disable_metrics_collection]{disable_metrics_collection} \tab Disables group metrics collection for the specified Auto Scaling group\cr
#'  \link[=autoscaling_enable_metrics_collection]{enable_metrics_collection} \tab Enables group metrics collection for the specified Auto Scaling group\cr
#'  \link[=autoscaling_enter_standby]{enter_standby} \tab Moves the specified instances into the standby state\cr
#'  \link[=autoscaling_execute_policy]{execute_policy} \tab Executes the specified policy\cr
#'  \link[=autoscaling_exit_standby]{exit_standby} \tab Moves the specified instances out of the standby state\cr
#'  \link[=autoscaling_get_predictive_scaling_forecast]{get_predictive_scaling_forecast} \tab Retrieves the forecast data for a predictive scaling policy\cr
#'  \link[=autoscaling_put_lifecycle_hook]{put_lifecycle_hook} \tab Creates or updates a lifecycle hook for the specified Auto Scaling group\cr
#'  \link[=autoscaling_put_notification_configuration]{put_notification_configuration} \tab Configures an Auto Scaling group to send notifications when specified events take place\cr
#'  \link[=autoscaling_put_scaling_policy]{put_scaling_policy} \tab Creates or updates a scaling policy for an Auto Scaling group\cr
#'  \link[=autoscaling_put_scheduled_update_group_action]{put_scheduled_update_group_action} \tab Creates or updates a scheduled scaling action for an Auto Scaling group\cr
#'  \link[=autoscaling_put_warm_pool]{put_warm_pool} \tab Creates or updates a warm pool for the specified Auto Scaling group\cr
#'  \link[=autoscaling_record_lifecycle_action_heartbeat]{record_lifecycle_action_heartbeat} \tab Records a heartbeat for the lifecycle action associated with the specified token or instance\cr
#'  \link[=autoscaling_resume_processes]{resume_processes} \tab Resumes the specified suspended auto scaling processes, or all suspended process, for the specified Auto Scaling group\cr
#'  \link[=autoscaling_rollback_instance_refresh]{rollback_instance_refresh} \tab Cancels an instance refresh that is in progress and rolls back any changes that it made\cr
#'  \link[=autoscaling_set_desired_capacity]{set_desired_capacity} \tab Sets the size of the specified Auto Scaling group\cr
#'  \link[=autoscaling_set_instance_health]{set_instance_health} \tab Sets the health status of the specified instance\cr
#'  \link[=autoscaling_set_instance_protection]{set_instance_protection} \tab Updates the instance protection settings of the specified instances\cr
#'  \link[=autoscaling_start_instance_refresh]{start_instance_refresh} \tab Starts an instance refresh\cr
#'  \link[=autoscaling_suspend_processes]{suspend_processes} \tab Suspends the specified auto scaling processes, or all processes, for the specified Auto Scaling group\cr
#'  \link[=autoscaling_terminate_instance_in_auto_scaling_group]{terminate_instance_in_auto_scaling_group} \tab Terminates the specified instance and optionally adjusts the desired group size\cr
#'  \link[=autoscaling_update_auto_scaling_group]{update_auto_scaling_group} \tab We strongly recommend that all Auto Scaling groups use launch templates to ensure full functionality for Amazon EC2 Auto Scaling and Amazon EC2
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname autoscaling
#' @export
autoscaling <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .autoscaling$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.autoscaling <- list()

.autoscaling$operations <- list()

.autoscaling$metadata <- list(
  service_name = "autoscaling",
  endpoints = list("^(us|eu|ap|sa|ca|me|af|il|mx)\\-\\w+\\-\\d+$" = list(endpoint = "autoscaling.{region}.amazonaws.com", global = FALSE), "^cn\\-\\w+\\-\\d+$" = list(endpoint = "autoscaling.{region}.amazonaws.com.cn", global = FALSE), "^us\\-gov\\-\\w+\\-\\d+$" = list(endpoint = "autoscaling.{region}.amazonaws.com", global = FALSE), "^us\\-iso\\-\\w+\\-\\d+$" = list(endpoint = "autoscaling.{region}.c2s.ic.gov", global = FALSE), "^us\\-isob\\-\\w+\\-\\d+$" = list(endpoint = "autoscaling.{region}.sc2s.sgov.gov", global = FALSE), "^eu\\-isoe\\-\\w+\\-\\d+$" = list(endpoint = "autoscaling.{region}.cloud.adc-e.uk", global = FALSE), "^us\\-isof\\-\\w+\\-\\d+$" = list(endpoint = "autoscaling.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Auto Scaling",
  api_version = "2011-01-01",
  signing_name = "autoscaling",
  json_version = "",
  target_prefix = ""
)

.autoscaling$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("query", "v4")
  new_service(.autoscaling$metadata, handlers, config, op)
}
