# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' AWS Service Catalog App Registry
#'
#' @description
#' Amazon Web Services Service Catalog AppRegistry enables organizations to
#' understand the application context of their Amazon Web Services
#' resources. AppRegistry provides a repository of your applications, their
#' resources, and the application metadata that you use within your
#' enterprise.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- appregistry(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- appregistry()
#' svc$associate_attribute_group(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=appregistry_associate_attribute_group]{associate_attribute_group} \tab Associates an attribute group with an application to augment the application's metadata with the group's attributes\cr
#'  \link[=appregistry_associate_resource]{associate_resource} \tab Associates a resource with an application\cr
#'  \link[=appregistry_create_application]{create_application} \tab Creates a new application that is the top-level node in a hierarchy of related cloud resource abstractions\cr
#'  \link[=appregistry_create_attribute_group]{create_attribute_group} \tab Creates a new attribute group as a container for user-defined attributes\cr
#'  \link[=appregistry_delete_application]{delete_application} \tab Deletes an application that is specified either by its application ID, name, or ARN\cr
#'  \link[=appregistry_delete_attribute_group]{delete_attribute_group} \tab Deletes an attribute group, specified either by its attribute group ID, name, or ARN\cr
#'  \link[=appregistry_disassociate_attribute_group]{disassociate_attribute_group} \tab Disassociates an attribute group from an application to remove the extra attributes contained in the attribute group from the application's metadata\cr
#'  \link[=appregistry_disassociate_resource]{disassociate_resource} \tab Disassociates a resource from application\cr
#'  \link[=appregistry_get_application]{get_application} \tab Retrieves metadata information about one of your applications\cr
#'  \link[=appregistry_get_associated_resource]{get_associated_resource} \tab Gets the resource associated with the application\cr
#'  \link[=appregistry_get_attribute_group]{get_attribute_group} \tab Retrieves an attribute group by its ARN, ID, or name\cr
#'  \link[=appregistry_get_configuration]{get_configuration} \tab Retrieves a TagKey configuration from an account\cr
#'  \link[=appregistry_list_applications]{list_applications} \tab Retrieves a list of all of your applications\cr
#'  \link[=appregistry_list_associated_attribute_groups]{list_associated_attribute_groups} \tab Lists all attribute groups that are associated with specified application\cr
#'  \link[=appregistry_list_associated_resources]{list_associated_resources} \tab Lists all of the resources that are associated with the specified application\cr
#'  \link[=appregistry_list_attribute_groups]{list_attribute_groups} \tab Lists all attribute groups which you have access to\cr
#'  \link[=appregistry_list_attribute_groups_for_application]{list_attribute_groups_for_application} \tab Lists the details of all attribute groups associated with a specific application\cr
#'  \link[=appregistry_list_tags_for_resource]{list_tags_for_resource} \tab Lists all of the tags on the resource\cr
#'  \link[=appregistry_put_configuration]{put_configuration} \tab Associates a TagKey configuration to an account\cr
#'  \link[=appregistry_sync_resource]{sync_resource} \tab Syncs the resource with current AppRegistry records\cr
#'  \link[=appregistry_tag_resource]{tag_resource} \tab Assigns one or more tags (key-value pairs) to the specified resource\cr
#'  \link[=appregistry_untag_resource]{untag_resource} \tab Removes tags from a resource\cr
#'  \link[=appregistry_update_application]{update_application} \tab Updates an existing application with new attributes\cr
#'  \link[=appregistry_update_attribute_group]{update_attribute_group} \tab Updates an existing attribute group with new details
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname appregistry
#' @export
appregistry <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .appregistry$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.appregistry <- list()

.appregistry$operations <- list()

.appregistry$metadata <- list(
  service_name = "appregistry",
  endpoints = list("*" = list(endpoint = "servicecatalog-appregistry.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "servicecatalog-appregistry.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "servicecatalog-appregistry.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "servicecatalog-appregistry.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "servicecatalog-appregistry.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "servicecatalog-appregistry.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "Service Catalog AppRegistry",
  api_version = "2020-06-24",
  signing_name = "servicecatalog",
  json_version = "1.1",
  target_prefix = ""
)

.appregistry$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.appregistry$metadata, handlers, config, op)
}
