% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssmincidents_service.R
\name{ssmincidents}
\alias{ssmincidents}
\title{AWS Systems Manager Incident Manager}
\usage{
ssmincidents(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Systems Manager Incident Manager is an incident management console
designed to help users mitigate and recover from incidents affecting
their Amazon Web Services-hosted applications. An incident is any
unplanned interruption or reduction in quality of services.

Incident Manager increases incident resolution by notifying responders
of impact, highlighting relevant troubleshooting data, and providing
collaboration tools to get services back up and running. To achieve the
primary goal of reducing the time-to-resolution of critical incidents,
Incident Manager automates response plans and enables responder team
escalation.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- ssmincidents(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=ssmincidents_create_replication_set]{create_replication_set} \tab A replication set replicates and encrypts your data to the provided Regions with the provided KMS key\cr
\link[=ssmincidents_create_response_plan]{create_response_plan} \tab Creates a response plan that automates the initial response to incidents\cr
\link[=ssmincidents_create_timeline_event]{create_timeline_event} \tab Creates a custom timeline event on the incident details page of an incident record\cr
\link[=ssmincidents_delete_incident_record]{delete_incident_record} \tab Delete an incident record from Incident Manager\cr
\link[=ssmincidents_delete_replication_set]{delete_replication_set} \tab Deletes all Regions in your replication set\cr
\link[=ssmincidents_delete_resource_policy]{delete_resource_policy} \tab Deletes the resource policy that Resource Access Manager uses to share your Incident Manager resource\cr
\link[=ssmincidents_delete_response_plan]{delete_response_plan} \tab Deletes the specified response plan\cr
\link[=ssmincidents_delete_timeline_event]{delete_timeline_event} \tab Deletes a timeline event from an incident\cr
\link[=ssmincidents_get_incident_record]{get_incident_record} \tab Returns the details for the specified incident record\cr
\link[=ssmincidents_get_replication_set]{get_replication_set} \tab Retrieve your Incident Manager replication set\cr
\link[=ssmincidents_get_resource_policies]{get_resource_policies} \tab Retrieves the resource policies attached to the specified response plan\cr
\link[=ssmincidents_get_response_plan]{get_response_plan} \tab Retrieves the details of the specified response plan\cr
\link[=ssmincidents_get_timeline_event]{get_timeline_event} \tab Retrieves a timeline event based on its ID and incident record\cr
\link[=ssmincidents_list_incident_records]{list_incident_records} \tab Lists all incident records in your account\cr
\link[=ssmincidents_list_related_items]{list_related_items} \tab List all related items for an incident record\cr
\link[=ssmincidents_list_replication_sets]{list_replication_sets} \tab Lists details about the replication set configured in your account\cr
\link[=ssmincidents_list_response_plans]{list_response_plans} \tab Lists all response plans in your account\cr
\link[=ssmincidents_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags that are attached to the specified response plan\cr
\link[=ssmincidents_list_timeline_events]{list_timeline_events} \tab Lists timeline events for the specified incident record\cr
\link[=ssmincidents_put_resource_policy]{put_resource_policy} \tab Adds a resource policy to the specified response plan\cr
\link[=ssmincidents_start_incident]{start_incident} \tab Used to start an incident from CloudWatch alarms, EventBridge events, or manually\cr
\link[=ssmincidents_tag_resource]{tag_resource} \tab Adds a tag to a response plan\cr
\link[=ssmincidents_untag_resource]{untag_resource} \tab Removes a tag from a resource\cr
\link[=ssmincidents_update_deletion_protection]{update_deletion_protection} \tab Update deletion protection to either allow or deny deletion of the final Region in a replication set\cr
\link[=ssmincidents_update_incident_record]{update_incident_record} \tab Update the details of an incident record\cr
\link[=ssmincidents_update_related_items]{update_related_items} \tab Add or remove related items from the related items tab of an incident record\cr
\link[=ssmincidents_update_replication_set]{update_replication_set} \tab Add or delete Regions from your replication set\cr
\link[=ssmincidents_update_response_plan]{update_response_plan} \tab Updates the specified response plan\cr
\link[=ssmincidents_update_timeline_event]{update_timeline_event} \tab Updates a timeline event
}
}

\examples{
\dontrun{
svc <- ssmincidents()
svc$create_replication_set(
  Foo = 123
)
}

}
