% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auditmanager_operations.R
\name{auditmanager_create_assessment_report}
\alias{auditmanager_create_assessment_report}
\title{Creates an assessment report for the specified assessment}
\usage{
auditmanager_create_assessment_report(
  name,
  description = NULL,
  assessmentId,
  queryStatement = NULL
)
}
\arguments{
\item{name}{[required] The name of the new assessment report.}

\item{description}{The description of the assessment report.}

\item{assessmentId}{[required] The identifier for the assessment.}

\item{queryStatement}{A SQL statement that represents an evidence finder query.

Provide this parameter when you want to generate an assessment report
from the results of an evidence finder search query. When you use this
parameter, Audit Manager generates a one-time report using only the
evidence from the query output. This report does not include any
assessment evidence that was manually \href{https://docs.aws.amazon.com/audit-manager/latest/userguide/generate-assessment-report.html#generate-assessment-report-include-evidence}{added to a report using the console},
or \href{https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_BatchAssociateAssessmentReportEvidence.html}{associated with a report using the API}.

To use this parameter, the
\href{https://docs.aws.amazon.com/audit-manager/latest/APIReference/API_EvidenceFinderEnablement.html#auditmanager-Type-EvidenceFinderEnablement-enablementStatus}{enablementStatus}
of evidence finder must be \code{ENABLED}.

For examples and help resolving \code{queryStatement} validation exceptions,
see \href{https://docs.aws.amazon.com/audit-manager/latest/userguide/evidence-finder-issues.html#querystatement-exceptions}{Troubleshooting evidence finder issues}
in the \emph{Audit Manager User Guide.}}
}
\description{
Creates an assessment report for the specified assessment.

See \url{https://www.paws-r-sdk.com/docs/auditmanager_create_assessment_report/} for full documentation.
}
\keyword{internal}
