% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_get_aggregate_conformance_pack_compliance_summary}
\alias{configservice_get_aggregate_conformance_pack_compliance_summary}
\title{Returns the count of compliant and noncompliant conformance packs across
all Amazon Web Services accounts and Amazon Web Services Regions in an
aggregator}
\usage{
configservice_get_aggregate_conformance_pack_compliance_summary(
  ConfigurationAggregatorName,
  Filters = NULL,
  GroupByKey = NULL,
  Limit = NULL,
  NextToken = NULL
)
}
\arguments{
\item{ConfigurationAggregatorName}{[required] The name of the configuration aggregator.}

\item{Filters}{Filters the results based on the
\code{AggregateConformancePackComplianceSummaryFilters} object.}

\item{GroupByKey}{Groups the result based on Amazon Web Services account ID or Amazon Web
Services Region.}

\item{Limit}{The maximum number of results returned on each page. The default is
maximum. If you specify 0, Config uses the default.}

\item{NextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}
}
\description{
Returns the count of compliant and noncompliant conformance packs across all Amazon Web Services accounts and Amazon Web Services Regions in an aggregator. You can filter based on Amazon Web Services account ID or Amazon Web Services Region.

See \url{https://paws-r.github.io/docs/configservice/get_aggregate_conformance_pack_compliance_summary.html} for full documentation.
}
\keyword{internal}
