% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_get_discovered_resource_counts}
\alias{configservice_get_discovered_resource_counts}
\title{Returns the resource types, the number of each resource type, and the
total number of resources that AWS Config is recording in this region
for your AWS account}
\usage{
configservice_get_discovered_resource_counts(resourceTypes, limit,
  nextToken)
}
\arguments{
\item{resourceTypes}{The comma-separated list that specifies the resource types that you want
AWS Config to return (for example, \code{"AWS::EC2::Instance"},
\code{"AWS::IAM::User"}).

If a value for \code{resourceTypes} is not specified, AWS Config returns all
resource types that AWS Config is recording in the region for your
account.

If the configuration recorder is turned off, AWS Config returns an empty
list of ResourceCount objects. If the configuration recorder is not
recording a specific resource type (for example, S3 buckets), that
resource type is not returned in the list of ResourceCount objects.}

\item{limit}{The maximum number of ResourceCount objects returned on each page. The
default is 100. You cannot specify a number greater than 100. If you
specify 0, AWS Config uses the default.}

\item{nextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}
}
\description{
Returns the resource types, the number of each resource type, and the
total number of resources that AWS Config is recording in this region
for your AWS account.
}
\details{
\strong{Example}
\enumerate{
\item AWS Config is recording three resource types in the US East (Ohio)
Region for your account: 25 EC2 instances, 20 IAM users, and 15 S3
buckets.
\item You make a call to the \code{GetDiscoveredResourceCounts} action and
specify that you want all resource types.
\item AWS Config returns the following:
\itemize{
\item The resource types (EC2 instances, IAM users, and S3 buckets).
\item The number of each resource type (25, 20, and 15).
\item The total number of all resources (60).
}
}

The response is paginated. By default, AWS Config lists 100
ResourceCount objects on each page. You can customize this number with
the \code{limit} parameter. The response includes a \code{nextToken} string. To
get the next page of results, run the request again and specify the
string for the \code{nextToken} parameter.

If you make a call to the GetDiscoveredResourceCounts action, you might
not immediately receive resource counts in the following situations:
\itemize{
\item You are a new AWS Config customer.
\item You just enabled resource recording.
}

It might take a few minutes for AWS Config to record and count your
resources. Wait a few minutes and then retry the
GetDiscoveredResourceCounts action.
}
\section{Request syntax}{
\preformatted{svc$get_discovered_resource_counts(
  resourceTypes = list(
    "string"
  ),
  limit = 123,
  nextToken = "string"
)
}
}

\keyword{internal}
