# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service
NULL

#' AWS Support
#'
#' @description
#' The AWS Support API reference is intended for programmers who need
#' detailed information about the AWS Support operations and data types.
#' This service enables you to manage your AWS Support cases
#' programmatically. It uses HTTP methods that return results in JSON
#' format.
#' 
#' The AWS Support service also exposes a set of [Trusted
#' Advisor](http://aws.amazon.com/premiumsupport/trustedadvisor/) features.
#' You can retrieve a list of checks and their descriptions, get check
#' results, specify checks to refresh, and get the refresh status of
#' checks.
#' 
#' The following list describes the AWS Support case management operations:
#' 
#' -   **Service names, issue categories, and available severity levels.**
#'     The DescribeServices and DescribeSeverityLevels operations return
#'     AWS service names, service codes, service categories, and problem
#'     severity levels. You use these values when you call the CreateCase
#'     operation.
#' 
#' -   **Case creation, case details, and case resolution.** The
#'     CreateCase, DescribeCases, DescribeAttachment, and ResolveCase
#'     operations create AWS Support cases, retrieve information about
#'     cases, and resolve cases.
#' 
#' -   **Case communication.** The DescribeCommunications,
#'     AddCommunicationToCase, and AddAttachmentsToSet operations retrieve
#'     and add communications and attachments to AWS Support cases.
#' 
#' The following list describes the operations available from the AWS
#' Support service for Trusted Advisor:
#' 
#' -   DescribeTrustedAdvisorChecks returns the list of checks that run
#'     against your AWS resources.
#' 
#' -   Using the `checkId` for a specific check returned by
#'     DescribeTrustedAdvisorChecks, you can call
#'     DescribeTrustedAdvisorCheckResult to obtain the results for the
#'     check you specified.
#' 
#' -   DescribeTrustedAdvisorCheckSummaries returns summarized results for
#'     one or more Trusted Advisor checks.
#' 
#' -   RefreshTrustedAdvisorCheck requests that Trusted Advisor rerun a
#'     specified check.
#' 
#' -   DescribeTrustedAdvisorCheckRefreshStatuses reports the refresh
#'     status of one or more checks.
#' 
#' For authentication of requests, AWS Support uses [Signature Version 4
#' Signing
#' Process](http://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
#' 
#' See [About the AWS Support
#' API](http://docs.aws.amazon.com/awssupport/latest/user/Welcome.html) in
#' the *AWS Support User Guide* for information about how to use this
#' service to create and manage your support cases, and how to call Trusted
#' Advisor for results of checks on your resources.
#'
#' @examples
#' \donttest{svc <- support()
#' svc$add_attachments_to_set(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=support_add_attachments_to_set]{add_attachments_to_set} \tab Adds one or more attachments to an attachment set \cr
#'  \link[=support_add_communication_to_case]{add_communication_to_case} \tab Adds additional customer communication to an AWS Support case \cr
#'  \link[=support_create_case]{create_case} \tab Creates a new case in the AWS Support Center \cr
#'  \link[=support_describe_attachment]{describe_attachment} \tab Returns the attachment that has the specified ID \cr
#'  \link[=support_describe_cases]{describe_cases} \tab Returns a list of cases that you specify by passing one or more case IDs \cr
#'  \link[=support_describe_communications]{describe_communications} \tab Returns communications (and attachments) for one or more support cases \cr
#'  \link[=support_describe_services]{describe_services} \tab Returns the current list of AWS services and a list of service categories that applies to each one \cr
#'  \link[=support_describe_severity_levels]{describe_severity_levels} \tab Returns the list of severity levels that you can assign to an AWS Support case \cr
#'  \link[=support_describe_trusted_advisor_check_refresh_statuses]{describe_trusted_advisor_check_refresh_statuses} \tab Returns the refresh status of the Trusted Advisor checks that have the specified check IDs \cr
#'  \link[=support_describe_trusted_advisor_check_result]{describe_trusted_advisor_check_result} \tab Returns the results of the Trusted Advisor check that has the specified check ID \cr
#'  \link[=support_describe_trusted_advisor_check_summaries]{describe_trusted_advisor_check_summaries} \tab Returns the summaries of the results of the Trusted Advisor checks that have the specified check IDs \cr
#'  \link[=support_describe_trusted_advisor_checks]{describe_trusted_advisor_checks} \tab Returns information about all available Trusted Advisor checks, including name, ID, category, description, and metadata \cr
#'  \link[=support_refresh_trusted_advisor_check]{refresh_trusted_advisor_check} \tab Requests a refresh of the Trusted Advisor check that has the specified check ID \cr
#'  \link[=support_resolve_case]{resolve_case} \tab Takes a caseId and returns the initial state of the case along with the state of the case after the call to ResolveCase completed
#' }
#'
#' @rdname support
#' @export
support <- function() {
  .support$operations
}

# Private API objects: metadata, handlers, interfaces, etc.
.support <- list()

.support$operations <- list()

.support$metadata <- list(
  service_name = "support",
  endpoints = list("*" = list(endpoint = "support.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "support.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "Support",
  api_version = "2013-04-15",
  signing_name = NULL,
  json_version = "1.1",
  target_prefix = "AWSSupport_20130415"
)

.support$handlers <- new_handlers("jsonrpc", "v4")

.support$service <- function() {
  new_service(.support$metadata, .support$handlers)
}
