% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/servicecatalog_operations.R
\name{servicecatalog_delete_provisioning_artifact}
\alias{servicecatalog_delete_provisioning_artifact}
\title{Deletes the specified provisioning artifact (also known as a version)
for the specified product}
\usage{
servicecatalog_delete_provisioning_artifact(AcceptLanguage, ProductId,
  ProvisioningArtifactId)
}
\arguments{
\item{AcceptLanguage}{The language code.
\itemize{
\item \code{en} - English (default)
\item \code{jp} - Japanese
\item \code{zh} - Chinese
}}

\item{ProductId}{[required] The product identifier.}

\item{ProvisioningArtifactId}{[required] The identifier of the provisioning artifact.}
}
\value{
An empty list.
}
\description{
Deletes the specified provisioning artifact (also known as a version)
for the specified product.

You cannot delete a provisioning artifact associated with a product that
was shared with you. You cannot delete the last provisioning artifact
for a product, because a product must have at least one provisioning
artifact.
}
\section{Request syntax}{
\preformatted{svc$delete_provisioning_artifact(
  AcceptLanguage = "string",
  ProductId = "string",
  ProvisioningArtifactId = "string"
)
}
}

\keyword{internal}
