% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_put_insight_selectors}
\alias{cloudtrail_put_insight_selectors}
\title{Lets you enable Insights event logging by specifying the Insights
selectors that you want to enable on an existing trail}
\usage{
cloudtrail_put_insight_selectors(TrailName, InsightSelectors)
}
\arguments{
\item{TrailName}{[required] The name of the CloudTrail trail for which you want to change or add
Insights selectors.}

\item{InsightSelectors}{[required] A JSON string that contains the insight types you want to log on a
trail. In this release, only \code{ApiCallRateInsight} is supported as an
insight type.}
}
\value{
A list with the following syntax:\preformatted{list(
  TrailARN = "string",
  InsightSelectors = list(
    list(
      InsightType = "ApiCallRateInsight"
    )
  )
)
}
}
\description{
Lets you enable Insights event logging by specifying the Insights
selectors that you want to enable on an existing trail. You also use
\code{\link[=cloudtrail_put_insight_selectors]{put_insight_selectors}} to turn off
Insights event logging, by passing an empty list of insight types. In
this release, only \code{ApiCallRateInsight} is supported as an Insights
selector.
}
\section{Request syntax}{
\preformatted{svc$put_insight_selectors(
  TrailName = "string",
  InsightSelectors = list(
    list(
      InsightType = "ApiCallRateInsight"
    )
  )
)
}
}

\keyword{internal}
