# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS Performance Insights
#'
#' @description
#' Amazon RDS Performance Insights
#' 
#' Amazon RDS Performance Insights enables you to monitor and explore
#' different dimensions of database load based on data captured from a
#' running DB instance. The guide provides detailed information about
#' Performance Insights data types, parameters and errors.
#' 
#' When Performance Insights is enabled, the Amazon RDS Performance
#' Insights API provides visibility into the performance of your DB
#' instance. Amazon CloudWatch provides the authoritative source for AWS
#' service-vended monitoring metrics. Performance Insights offers a
#' domain-specific view of DB load.
#' 
#' DB load is measured as Average Active Sessions. Performance Insights
#' provides the data to API consumers as a two-dimensional time-series
#' dataset. The time dimension provides DB load data for each time point in
#' the queried time range. Each time point decomposes overall load in
#' relation to the requested dimensions, measured at that time point.
#' Examples include SQL, Wait event, User, and Host.
#' 
#' -   To learn more about Performance Insights and Amazon Aurora DB
#'     instances, go to the [Amazon Aurora User
#'     Guide](https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/USER_PerfInsights.html).
#' 
#' -   To learn more about Performance Insights and Amazon RDS DB
#'     instances, go to the [Amazon RDS User
#'     Guide](https://docs.aws.amazon.com/AmazonRDS/latest/UserGuide/USER_PerfInsights.html).
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- pi(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- pi()
#' svc$describe_dimension_keys(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=pi_describe_dimension_keys]{describe_dimension_keys} \tab For a specific time period, retrieve the top N dimension keys for a metric\cr
#'  \link[=pi_get_resource_metrics]{get_resource_metrics} \tab Retrieve Performance Insights metrics for a set of data sources, over a time period
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname pi
#' @export
pi <- function(config = list()) {
  svc <- .pi$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.pi <- list()

.pi$operations <- list()

.pi$metadata <- list(
  service_name = "pi",
  endpoints = list("*" = list(endpoint = "pi.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "pi.{region}.amazonaws.com.cn", global = FALSE), "us-iso-*" = list(endpoint = "pi.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "pi.{region}.sc2s.sgov.gov", global = FALSE)),
  service_id = "PI",
  api_version = "2018-02-27",
  signing_name = "pi",
  json_version = "1.1",
  target_prefix = "PerformanceInsightsv20180227"
)

.pi$service <- function(config = list()) {
  handlers <- new_handlers("jsonrpc", "v4")
  new_service(.pi$metadata, handlers, config)
}
