% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_tag_log_group}
\alias{cloudwatchlogs_tag_log_group}
\title{Adds or updates the specified tags for the specified log group}
\usage{
cloudwatchlogs_tag_log_group(logGroupName, tags)
}
\arguments{
\item{logGroupName}{[required] The name of the log group.}

\item{tags}{[required] The key-value pairs to use for the tags.}
}
\description{
Adds or updates the specified tags for the specified log group.

To list the tags for a log group, use
\href{https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_ListTagsLogGroup.html}{ListTagsLogGroup}.
To remove tags, use
\href{https://docs.aws.amazon.com/AmazonCloudWatchLogs/latest/APIReference/API_UntagLogGroup.html}{UntagLogGroup}.

For more information about tags, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/logs/Working-with-log-groups-and-streams.html#log-group-tagging}{Tag Log Groups in Amazon CloudWatch Logs}
in the \emph{Amazon CloudWatch Logs User Guide}.
}
\section{Request syntax}{
\preformatted{svc$tag_log_group(
  logGroupName = "string",
  tags = list(
    "string"
  )
)
}
}

\keyword{internal}
