% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applicationinsights_operations.R
\name{applicationinsights_create_log_pattern}
\alias{applicationinsights_create_log_pattern}
\title{Adds an log pattern to a LogPatternSet}
\usage{
applicationinsights_create_log_pattern(ResourceGroupName,
  PatternSetName, PatternName, Pattern, Rank)
}
\arguments{
\item{ResourceGroupName}{[required] The name of the resource group.}

\item{PatternSetName}{[required] The name of the log pattern set.}

\item{PatternName}{[required] The name of the log pattern.}

\item{Pattern}{[required] The log pattern. The pattern must be DFA compatible. Patterns that
utilize forward lookahead or backreference constructions are not
supported.}

\item{Rank}{[required] Rank of the log pattern. Must be a value between \code{1} and \verb{1,000,000}.
The patterns are sorted by rank, so we recommend that you set your
highest priority patterns with the lowest rank. A pattern of rank \code{1}
will be the first to get matched to a log line. A pattern of rank
\verb{1,000,000} will be last to get matched. When you configure custom log
patterns from the console, a \code{Low} severity pattern translates to a
\verb{750,000} rank. A \code{Medium} severity pattern translates to a \verb{500,000}
rank. And a \code{High} severity pattern translates to a \verb{250,000} rank. Rank
values less than \code{1} or greater than \verb{1,000,000} are reserved for
AWS-provided patterns.}
}
\description{
Adds an log pattern to a \code{LogPatternSet}.
}
\section{Request syntax}{
\preformatted{svc$create_log_pattern(
  ResourceGroupName = "string",
  PatternSetName = "string",
  PatternName = "string",
  Pattern = "string",
  Rank = 123
)
}
}

\keyword{internal}
