% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_describe_metric_filters}
\alias{cloudwatchlogs_describe_metric_filters}
\title{Lists the specified metric filters}
\usage{
cloudwatchlogs_describe_metric_filters(logGroupName, filterNamePrefix,
  nextToken, limit, metricName, metricNamespace)
}
\arguments{
\item{logGroupName}{The name of the log group.}

\item{filterNamePrefix}{The prefix to match.}

\item{nextToken}{The token for the next set of items to return. (You received this token
from a previous call.)}

\item{limit}{The maximum number of items returned. If you don't specify a value, the
default is up to 50 items.}

\item{metricName}{Filters results to include only those with the specified metric name. If
you include this parameter in your request, you must also include the
\code{metricNamespace} parameter.}

\item{metricNamespace}{Filters results to include only those in the specified namespace. If you
include this parameter in your request, you must also include the
\code{metricName} parameter.}
}
\description{
Lists the specified metric filters. You can list all the metric filters
or filter the results by log name, prefix, metric name, or metric
namespace. The results are ASCII-sorted by filter name.
}
\section{Request syntax}{
\preformatted{svc$describe_metric_filters(
  logGroupName = "string",
  filterNamePrefix = "string",
  nextToken = "string",
  limit = 123,
  metricName = "string",
  metricNamespace = "string"
)
}
}

\keyword{internal}
