% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_update_auto_scaling_group}
\alias{autoscaling_update_auto_scaling_group}
\title{Updates the configuration for the specified Auto Scaling group}
\usage{
autoscaling_update_auto_scaling_group(AutoScalingGroupName,
  LaunchConfigurationName, LaunchTemplate, MixedInstancesPolicy, MinSize,
  MaxSize, DesiredCapacity, DefaultCooldown, AvailabilityZones,
  HealthCheckType, HealthCheckGracePeriod, PlacementGroup,
  VPCZoneIdentifier, TerminationPolicies,
  NewInstancesProtectedFromScaleIn, ServiceLinkedRoleARN)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{LaunchConfigurationName}{The name of the launch configuration. If you specify this parameter, you
can't specify a launch template or a mixed instances policy.}

\item{LaunchTemplate}{The launch template and version to use to specify the updates. If you
specify this parameter, you can't specify a launch configuration or a
mixed instances policy.}

\item{MixedInstancesPolicy}{The mixed instances policy to use to specify the updates. If you specify
this parameter, you can't specify a launch configuration or a launch
template.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/asg-purchase-options.html}{Auto Scaling Groups with Multiple Instance Types and Purchase Options}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{MinSize}{The minimum size of the Auto Scaling group.}

\item{MaxSize}{The maximum size of the Auto Scaling group.}

\item{DesiredCapacity}{The number of EC2 instances that should be running in the Auto Scaling
group. This number must be greater than or equal to the minimum size of
the group and less than or equal to the maximum size of the group.}

\item{DefaultCooldown}{The amount of time, in seconds, after a scaling activity completes
before another scaling activity can start. The default value is \code{300}.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/Cooldown.html}{Scaling Cooldowns}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{AvailabilityZones}{One or more Availability Zones for the group.}

\item{HealthCheckType}{The service to use for the health checks. The valid values are \code{EC2} and
\code{ELB}. If you configure an Auto Scaling group to use ELB health checks,
it considers the instance unhealthy if it fails either the EC2 status
checks or the load balancer health checks.}

\item{HealthCheckGracePeriod}{The amount of time, in seconds, that Amazon EC2 Auto Scaling waits
before checking the health status of an EC2 instance that has come into
service. The default value is \code{0}.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/healthcheck.html}{Health Checks for Auto Scaling Instances}
in the \emph{Amazon EC2 Auto Scaling User Guide}.

Conditional: This parameter is required if you are adding an \code{ELB}
health check.}

\item{PlacementGroup}{The name of the placement group into which to launch your instances, if
any. A placement group is a logical grouping of instances within a
single Availability Zone. You cannot specify multiple Availability Zones
and a placement group. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html}{Placement Groups}
in the \emph{Amazon EC2 User Guide for Linux Instances}.}

\item{VPCZoneIdentifier}{A comma-separated list of subnet IDs, if you are launching into a VPC.

If you specify \code{VPCZoneIdentifier} with \code{AvailabilityZones}, the subnets
that you specify for this parameter must reside in those Availability
Zones.}

\item{TerminationPolicies}{A standalone termination policy or a list of termination policies used
to select the instance to terminate. The policies are executed in the
order that they are listed.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html}{Controlling Which Instances Auto Scaling Terminates During Scale In}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{NewInstancesProtectedFromScaleIn}{Indicates whether newly launched instances are protected from
termination by Amazon EC2 Auto Scaling when scaling in.

For more information about preventing instances from terminating on
scale in, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-instance-termination.html#instance-protection}{Instance Protection}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}

\item{ServiceLinkedRoleARN}{The Amazon Resource Name (ARN) of the service-linked role that the Auto
Scaling group uses to call other AWS services on your behalf. For more
information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/autoscaling-service-linked-role.html}{Service-Linked Roles}
in the \emph{Amazon EC2 Auto Scaling User Guide}.}
}
\description{
Updates the configuration for the specified Auto Scaling group.
}
\details{
The new settings take effect on any scaling activities after this call
returns. Scaling activities that are currently in progress aren't
affected.

To update an Auto Scaling group with a launch configuration with
\code{InstanceMonitoring} set to \code{false}, you must first disable the
collection of group metrics. Otherwise, you get an error. If you have
previously enabled the collection of group metrics, you can disable it
using DisableMetricsCollection.

Note the following:
\itemize{
\item If you specify a new value for \code{MinSize} without specifying a value
for \code{DesiredCapacity}, and the new \code{MinSize} is larger than the
current size of the group, we implicitly call SetDesiredCapacity to
set the size of the group to the new value of \code{MinSize}.
\item If you specify a new value for \code{MaxSize} without specifying a value
for \code{DesiredCapacity}, and the new \code{MaxSize} is smaller than the
current size of the group, we implicitly call SetDesiredCapacity to
set the size of the group to the new value of \code{MaxSize}.
\item All other optional parameters are left unchanged if not specified.
}
}
\section{Request syntax}{
\preformatted{svc$update_auto_scaling_group(
  AutoScalingGroupName = "string",
  LaunchConfigurationName = "string",
  LaunchTemplate = list(
    LaunchTemplateId = "string",
    LaunchTemplateName = "string",
    Version = "string"
  ),
  MixedInstancesPolicy = list(
    LaunchTemplate = list(
      LaunchTemplateSpecification = list(
        LaunchTemplateId = "string",
        LaunchTemplateName = "string",
        Version = "string"
      ),
      Overrides = list(
        list(
          InstanceType = "string"
        )
      )
    ),
    InstancesDistribution = list(
      OnDemandAllocationStrategy = "string",
      OnDemandBaseCapacity = 123,
      OnDemandPercentageAboveBaseCapacity = 123,
      SpotAllocationStrategy = "string",
      SpotInstancePools = 123,
      SpotMaxPrice = "string"
    )
  ),
  MinSize = 123,
  MaxSize = 123,
  DesiredCapacity = 123,
  DefaultCooldown = 123,
  AvailabilityZones = list(
    "string"
  ),
  HealthCheckType = "string",
  HealthCheckGracePeriod = 123,
  PlacementGroup = "string",
  VPCZoneIdentifier = "string",
  TerminationPolicies = list(
    "string"
  ),
  NewInstancesProtectedFromScaleIn = TRUE|FALSE,
  ServiceLinkedRoleARN = "string"
)
}
}

\examples{
# This example updates the launch configuration of the specified Auto
# Scaling group.
\donttest{svc$update_auto_scaling_group(
  AutoScalingGroupName = "my-auto-scaling-group",
  LaunchConfigurationName = "new-launch-config"
)}

# This example updates the minimum size and maximum size of the specified
# Auto Scaling group.
\donttest{svc$update_auto_scaling_group(
  AutoScalingGroupName = "my-auto-scaling-group",
  MaxSize = 3L,
  MinSize = 1L
)}

# This example enables instance protection for the specified Auto Scaling
# group.
\donttest{svc$update_auto_scaling_group(
  AutoScalingGroupName = "my-auto-scaling-group",
  NewInstancesProtectedFromScaleIn = TRUE
)}

}
\keyword{internal}
