% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/translate_operations.R
\name{translate_create_parallel_data}
\alias{translate_create_parallel_data}
\title{Creates a parallel data resource in Amazon Translate by importing an
input file from Amazon S3}
\usage{
translate_create_parallel_data(
  Name,
  Description = NULL,
  ParallelDataConfig,
  EncryptionKey = NULL,
  ClientToken
)
}
\arguments{
\item{Name}{[required] A custom name for the parallel data resource in Amazon Translate. You
must assign a name that is unique in the account and region.}

\item{Description}{A custom description for the parallel data resource in Amazon Translate.}

\item{ParallelDataConfig}{[required] Specifies the format and S3 location of the parallel data input file.}

\item{EncryptionKey}{}

\item{ClientToken}{[required] A unique identifier for the request. This token is automatically
generated when you use Amazon Translate through an AWS SDK.}
}
\description{
Creates a parallel data resource in Amazon Translate by importing an input file from Amazon S3. Parallel data files contain examples that show how you want segments of text to be translated. By adding parallel data, you can influence the style, tone, and word choice in your translation output.

See \url{https://paws-r.github.io/docs/translate/create_parallel_data.html} for full documentation.
}
\keyword{internal}
