% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_start_content_moderation}
\alias{rekognition_start_content_moderation}
\title{Starts asynchronous detection of inappropriate, unwanted, or offensive
content in a stored video}
\usage{
rekognition_start_content_moderation(
  Video,
  MinConfidence = NULL,
  ClientRequestToken = NULL,
  NotificationChannel = NULL,
  JobTag = NULL
)
}
\arguments{
\item{Video}{[required] The video in which you want to detect inappropriate, unwanted, or
offensive content. The video must be stored in an Amazon S3 bucket.}

\item{MinConfidence}{Specifies the minimum confidence that Amazon Rekognition must have in
order to return a moderated content label. Confidence represents how
certain Amazon Rekognition is that the moderated content is correctly
identified. 0 is the lowest confidence. 100 is the highest confidence.
Amazon Rekognition doesn't return any moderated content labels with a
confidence level lower than this specified value. If you don't specify
\code{MinConfidence},
\code{\link[=rekognition_get_content_moderation]{get_content_moderation}} returns
labels with confidence values greater than or equal to 50 percent.}

\item{ClientRequestToken}{Idempotent token used to identify the start request. If you use the same
token with multiple
\code{\link[=rekognition_start_content_moderation]{start_content_moderation}}
requests, the same \code{JobId} is returned. Use \code{ClientRequestToken} to
prevent the same job from being accidently started more than once.}

\item{NotificationChannel}{The Amazon SNS topic ARN that you want Amazon Rekognition Video to
publish the completion status of the content analysis to. The Amazon SNS
topic must have a topic name that begins with \emph{AmazonRekognition} if you
are using the AmazonRekognitionServiceRole permissions policy to access
the topic.}

\item{JobTag}{An identifier you specify that's returned in the completion notification
that's published to your Amazon Simple Notification Service topic. For
example, you can use \code{JobTag} to group related jobs and identify them in
the completion notification.}
}
\description{
Starts asynchronous detection of inappropriate, unwanted, or offensive content in a stored video. For a list of moderation labels in Amazon Rekognition, see \href{https://docs.aws.amazon.com/rekognition/latest/dg/moderation.html#moderation-api}{Using the image and video moderation APIs}.

See \url{https://paws-r.github.io/docs/rekognition/start_content_moderation.html} for full documentation.
}
\keyword{internal}
