% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexruntimev2_operations.R
\name{lexruntimev2_recognize_text}
\alias{lexruntimev2_recognize_text}
\title{Sends user input to Amazon Lex V2}
\usage{
lexruntimev2_recognize_text(
  botId,
  botAliasId,
  localeId,
  sessionId,
  text,
  sessionState = NULL,
  requestAttributes = NULL
)
}
\arguments{
\item{botId}{[required] The identifier of the bot that processes the request.}

\item{botAliasId}{[required] The alias identifier in use for the bot that processes the request.}

\item{localeId}{[required] The locale where the session is in use.}

\item{sessionId}{[required] The identifier of the user session that is having the conversation.}

\item{text}{[required] The text that the user entered. Amazon Lex V2 interprets this text.}

\item{sessionState}{The current state of the dialog between the user and the bot.}

\item{requestAttributes}{Request-specific information passed between the client application and
Amazon Lex V2

The namespace \verb{x-amz-lex:} is reserved for special attributes. Don't
create any request attributes with the prefix \verb{x-amz-lex:}.}
}
\description{
Sends user input to Amazon Lex V2. Client applications use this API to send requests to Amazon Lex V2 at runtime. Amazon Lex V2 then interprets the user input using the machine learning model that it build for the bot.

See \url{https://paws-r.github.io/docs/lexruntimev2/recognize_text.html} for full documentation.
}
\keyword{internal}
