% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_create_intent_version}
\alias{lexmodelbuildingservice_create_intent_version}
\title{Creates a new version of an intent based on the $LATEST version of the
intent}
\usage{
lexmodelbuildingservice_create_intent_version(name, checksum = NULL)
}
\arguments{
\item{name}{[required] The name of the intent that you want to create a new version of. The
name is case sensitive.}

\item{checksum}{Checksum of the \verb{$LATEST} version of the intent that should be used to
create the new version. If you specify a checksum and the \verb{$LATEST}
version of the intent has a different checksum, Amazon Lex returns a
\code{PreconditionFailedException} exception and doesn't publish a new
version. If you don't specify a checksum, Amazon Lex publishes the
\verb{$LATEST} version.}
}
\description{
Creates a new version of an intent based on the \verb{$LATEST} version of the intent. If the \verb{$LATEST} version of this intent hasn't changed since you last updated it, Amazon Lex doesn't create a new version. It returns the last version you created.

See \url{https://paws-r.github.io/docs/lexmodelbuildingservice/create_intent_version.html} for full documentation.
}
\keyword{internal}
