% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecastservice_operations.R
\name{forecastservice_create_explainability}
\alias{forecastservice_create_explainability}
\title{Explainability is only available for Forecasts and Predictors generated
from an AutoPredictor (CreateAutoPredictor)}
\usage{
forecastservice_create_explainability(
  ExplainabilityName,
  ResourceArn,
  ExplainabilityConfig,
  DataSource = NULL,
  Schema = NULL,
  EnableVisualization = NULL,
  StartDateTime = NULL,
  EndDateTime = NULL,
  Tags = NULL
)
}
\arguments{
\item{ExplainabilityName}{[required] A unique name for the Explainability.}

\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the Predictor or Forecast used to
create the Explainability.}

\item{ExplainabilityConfig}{[required] The configuration settings that define the granularity of time series
and time points for the Explainability.}

\item{DataSource}{}

\item{Schema}{}

\item{EnableVisualization}{Create an Explainability visualization that is viewable within the AWS
console.}

\item{StartDateTime}{If \code{TimePointGranularity} is set to \code{SPECIFIC}, define the first point
for the Explainability.

Use the following timestamp format: yyyy-MM-ddTHH:mm:ss (example:
2015-01-01T20:00:00)}

\item{EndDateTime}{If \code{TimePointGranularity} is set to \code{SPECIFIC}, define the last time
point for the Explainability.

Use the following timestamp format: yyyy-MM-ddTHH:mm:ss (example:
2015-01-01T20:00:00)}

\item{Tags}{Optional metadata to help you categorize and organize your resources.
Each tag consists of a key and an optional value, both of which you
define. Tag keys and values are case sensitive.

The following restrictions apply to tags:
\itemize{
\item For each resource, each tag key must be unique and each tag key must
have one value.
\item Maximum number of tags per resource: 50.
\item Maximum key length: 128 Unicode characters in UTF-8.
\item Maximum value length: 256 Unicode characters in UTF-8.
\item Accepted characters: all letters and numbers, spaces representable
in UTF-8, and + - = . _ : / @. If your tagging schema is used
across other services and resources, the character restrictions of
those services also apply.
\item Key prefixes cannot include any upper or lowercase combination of
\verb{aws:} or \verb{AWS:}. Values can have this prefix. If a tag value has
\code{aws} as its prefix but the key does not, Forecast considers it to
be a user tag and will count against the limit of 50 tags. Tags with
only the key prefix of \code{aws} do not count against your tags per
resource limit. You cannot edit or delete tag keys with this prefix.
}}
}
\description{
Explainability is only available for Forecasts and Predictors generated from an AutoPredictor (\code{\link[=forecastservice_create_auto_predictor]{create_auto_predictor}})

See \url{https://paws-r.github.io/docs/forecastservice/create_explainability.html} for full documentation.
}
\keyword{internal}
