% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_detect_entities}
\alias{comprehend_detect_entities}
\title{Inspects text for named entities, and returns information about them}
\usage{
comprehend_detect_entities(Text, LanguageCode = NULL, EndpointArn = NULL)
}
\arguments{
\item{Text}{[required] A UTF-8 text string. Each string must contain fewer that 5,000 bytes of
UTF-8 encoded characters.}

\item{LanguageCode}{The language of the input documents. You can specify any of the primary
languages supported by Amazon Comprehend. All documents must be in the
same language.

If your request includes the endpoint for a custom entity recognition
model, Amazon Comprehend uses the language of your custom model, and it
ignores any language code that you specify here.}

\item{EndpointArn}{The Amazon Resource Name of an endpoint that is associated with a custom
entity recognition model. Provide an endpoint if you want to detect
entities by using your own custom model instead of the default model
that is used by Amazon Comprehend.

If you specify an endpoint, Amazon Comprehend uses the language of your
custom model, and it ignores any language code that you provide in your
request.

For information about endpoints, see \href{https://docs.aws.amazon.com/comprehend/latest/dg/manage-endpoints.html}{Managing endpoints}.}
}
\description{
Inspects text for named entities, and returns information about them. For more information, about named entities, see how-entities.

See \url{https://paws-r.github.io/docs/comprehend/detect_entities.html} for full documentation.
}
\keyword{internal}
