% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_create_intent_version}
\alias{lexmodelbuildingservice_create_intent_version}
\title{Creates a new version of an intent based on the $LATEST version of the
intent}
\usage{
lexmodelbuildingservice_create_intent_version(name, checksum)
}
\arguments{
\item{name}{[required] The name of the intent that you want to create a new version of. The
name is case sensitive.}

\item{checksum}{Checksum of the \code{$LATEST} version of the intent that should be used to
create the new version. If you specify a checksum and the \code{$LATEST}
version of the intent has a different checksum, Amazon Lex returns a
\code{PreconditionFailedException} exception and doesn't publish a new
version. If you don't specify a checksum, Amazon Lex publishes the
\code{$LATEST} version.}
}
\description{
Creates a new version of an intent based on the \code{$LATEST} version of the
intent. If the \code{$LATEST} version of this intent hasn't changed since
you last updated it, Amazon Lex doesn't create a new version. It
returns the last version you created.
}
\details{
You can update only the \code{$LATEST} version of the intent. You can't
update the numbered versions that you create with the
\code{CreateIntentVersion} operation.

When you create a version of an intent, Amazon Lex sets the version to
\enumerate{
\item Subsequent versions increment by 1. For more information, see
versioning-intro.
}

This operation requires permissions to perform the
\code{lex:CreateIntentVersion} action.
}
\section{Request syntax}{
\preformatted{svc$create_intent_version(
  name = "string",
  checksum = "string"
)
}
}

\keyword{internal}
