% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_endpoint}
\alias{sagemaker_create_endpoint}
\title{Creates an endpoint using the endpoint configuration specified in the
request}
\usage{
sagemaker_create_endpoint(EndpointName, EndpointConfigName, Tags)
}
\arguments{
\item{EndpointName}{[required] The name of the endpoint.The name must be unique within an AWS Region in
your AWS account. The name is case-insensitive in
\code{\link[=sagemaker_create_endpoint]{create_endpoint}}, but the case is
preserved and must be matched in .}

\item{EndpointConfigName}{[required] The name of an endpoint configuration. For more information, see
\code{\link[=sagemaker_create_endpoint_config]{create_endpoint_config}}.}

\item{Tags}{An array of key-value pairs. You can use tags to categorize your AWS
resources in different ways, for example, by purpose, owner, or
environment. For more information, see \href{https://docs.aws.amazon.com/general/latest/gr/aws_tagging.html}{Tagging AWS Resources}.}
}
\value{
A list with the following syntax:\preformatted{list(
  EndpointArn = "string"
)
}
}
\description{
Creates an endpoint using the endpoint configuration specified in the
request. Amazon SageMaker uses the endpoint to provision resources and
deploy models. You create the endpoint configuration with the
\code{\link[=sagemaker_create_endpoint_config]{create_endpoint_config}} API.

Use this API to deploy models using Amazon SageMaker hosting services.

For an example that calls this method when deploying a model to Amazon
SageMaker hosting services, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/#ex1-deploy-model-boto}{Deploy the Model to Amazon SageMaker Hosting Services (AWS SDK for Python (Boto 3)).}

You must not delete an \code{EndpointConfig} that is in use by an endpoint
that is live or while the \code{\link[=sagemaker_update_endpoint]{update_endpoint}}
or \code{\link[=sagemaker_create_endpoint]{create_endpoint}} operations are being
performed on the endpoint. To update an endpoint, you must create a new
\code{EndpointConfig}.

The endpoint name must be unique within an AWS Region in your AWS
account.

When it receives the request, Amazon SageMaker creates the endpoint,
launches the resources (ML compute instances), and deploys the model(s)
on them.

When you call \code{\link[=sagemaker_create_endpoint]{create_endpoint}}, a load
call is made to DynamoDB to verify that your endpoint configuration
exists. When you read data from a DynamoDB table supporting
\href{https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/HowItWorks.ReadConsistency.html}{\verb{Eventually Consistent Reads}}
, the response might not reflect the results of a recently completed
write operation. The response might include some stale data. If the
dependent entities are not yet in DynamoDB, this causes a validation
error. If you repeat your read request after a short time, the response
should return the latest data. So retry logic is recommended to handle
these possible issues. We also recommend that customers call
\code{\link[=sagemaker_describe_endpoint_config]{describe_endpoint_config}} before
calling \code{\link[=sagemaker_create_endpoint]{create_endpoint}} to minimize the
potential impact of a DynamoDB eventually consistent read.

When Amazon SageMaker receives the request, it sets the endpoint status
to \code{Creating}. After it creates the endpoint, it sets the status to
\code{InService}. Amazon SageMaker can then process incoming requests for
inferences. To check the status of an endpoint, use the
\code{\link[=sagemaker_describe_endpoint]{describe_endpoint}} API.

If any of the models hosted at this endpoint get model data from an
Amazon S3 location, Amazon SageMaker uses AWS Security Token Service to
download model artifacts from the S3 path you provided. AWS STS is
activated in your IAM user account by default. If you previously
deactivated AWS STS for a region, you need to reactivate AWS STS for
that region. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_credentials_temp_enable-regions.html}{Activating and Deactivating AWS STS in an AWS Region}
in the \emph{AWS Identity and Access Management User Guide}.

To add the IAM role policies for using this API operation, go to the IAM
console, and choose Roles in the left navigation pane. Search the IAM
role that you want to grant access to use the
\code{\link[=sagemaker_create_endpoint]{create_endpoint}} and
\code{\link[=sagemaker_create_endpoint_config]{create_endpoint_config}} API
operations, add the following policies to the role.
\itemize{
\item Option 1: For a full Amazon SageMaker access, search and attach the
\code{AmazonSageMakerFullAccess} policy.
\item Option 2: For granting a limited access to an IAM role, paste the
following Action elements manually into the JSON file of the IAM
role:

\verb{"Action": ["sagemaker:CreateEndpoint", "sagemaker:CreateEndpointConfig"]}

\verb{"Resource": [}

\code{"arn:aws:sagemaker:region:account-id:endpoint/endpointName"}

\code{"arn:aws:sagemaker:region:account-id:endpoint-config/endpointConfigName"}

\verb{]}

For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/api-permissions-reference.html}{Amazon SageMaker API Permissions: Actions, Permissions, and Resources Reference}.
}

[`\preformatted{`"arn:aws:sagemaker:region:account-id:endpoint/endpointName"`

`"arn:aws:sagemaker:region:account-id:endpoint-config/endpointConfigName"`

`]: R:\%60\%0A\%0A\%20\%20\%20\%20\%60\%22arn:aws:sagemaker:region:account-id:endpoint/endpointName\%22\%60\%0A\%0A\%20\%20\%20\%20\%60\%22arn:aws:sagemaker:region:account-id:endpoint-config/endpointConfigName\%22\%60\%0A\%0A\%20\%20\%20\%20\%60
}
}
\section{Request syntax}{
\preformatted{svc$create_endpoint(
  EndpointName = "string",
  EndpointConfigName = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
