% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comprehend_operations.R
\name{comprehend_describe_document_classification_job}
\alias{comprehend_describe_document_classification_job}
\title{Gets the properties associated with a document classification job}
\usage{
comprehend_describe_document_classification_job(JobId)
}
\arguments{
\item{JobId}{[required] The identifier that Amazon Comprehend generated for the job. The
operation returns this identifier in its response.}
}
\value{
A list with the following syntax:\preformatted{list(
  DocumentClassificationJobProperties = list(
    JobId = "string",
    JobName = "string",
    JobStatus = "SUBMITTED"|"IN_PROGRESS"|"COMPLETED"|"FAILED"|"STOP_REQUESTED"|"STOPPED",
    Message = "string",
    SubmitTime = as.POSIXct(
      "2015-01-01"
    ),
    EndTime = as.POSIXct(
      "2015-01-01"
    ),
    DocumentClassifierArn = "string",
    InputDataConfig = list(
      S3Uri = "string",
      InputFormat = "ONE_DOC_PER_FILE"|"ONE_DOC_PER_LINE"
    ),
    OutputDataConfig = list(
      S3Uri = "string",
      KmsKeyId = "string"
    ),
    DataAccessRoleArn = "string",
    VolumeKmsKeyId = "string",
    VpcConfig = list(
      SecurityGroupIds = list(
        "string"
      ),
      Subnets = list(
        "string"
      )
    )
  )
)
}
}
\description{
Gets the properties associated with a document classification job. Use
this operation to get the status of a classification job.
}
\section{Request syntax}{
\preformatted{svc$describe_document_classification_job(
  JobId = "string"
)
}
}

\keyword{internal}
