% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_list_experiments}
\alias{sagemaker_list_experiments}
\title{Lists all the experiments in your account}
\usage{
sagemaker_list_experiments(CreatedAfter, CreatedBefore, SortBy,
  SortOrder, NextToken, MaxResults)
}
\arguments{
\item{CreatedAfter}{A filter that returns only experiments created after the specified time.}

\item{CreatedBefore}{A filter that returns only experiments created before the specified
time.}

\item{SortBy}{The property used to sort results. The default value is \code{CreationTime}.}

\item{SortOrder}{The sort order. The default value is \code{Descending}.}

\item{NextToken}{If the previous call to \code{\link[=sagemaker_list_experiments]{list_experiments}}
didn't return the full set of experiments, the call returns a token for
getting the next set of experiments.}

\item{MaxResults}{The maximum number of experiments to return in the response. The default
value is 10.}
}
\value{
A list with the following syntax:\preformatted{list(
  ExperimentSummaries = list(
    list(
      ExperimentArn = "string",
      ExperimentName = "string",
      DisplayName = "string",
      ExperimentSource = list(
        SourceArn = "string",
        SourceType = "string"
      ),
      CreationTime = as.POSIXct(
        "2015-01-01"
      ),
      LastModifiedTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists all the experiments in your account. The list can be filtered to
show only experiments that were created in a specific time range. The
list can be sorted by experiment name or creation time.
}
\section{Request syntax}{
\preformatted{svc$list_experiments(
  CreatedAfter = as.POSIXct(
    "2015-01-01"
  ),
  CreatedBefore = as.POSIXct(
    "2015-01-01"
  ),
  SortBy = "Name"|"CreationTime",
  SortOrder = "Ascending"|"Descending",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
