% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_detect_labels}
\alias{rekognition_detect_labels}
\title{Detects instances of real-world entities within an image (JPEG or PNG)
provided as input}
\usage{
rekognition_detect_labels(Image, MaxLabels, MinConfidence)
}
\arguments{
\item{Image}{[required] The input image as base64-encoded bytes or an S3 object. If you use the
AWS CLI to call Amazon Rekognition operations, passing image bytes is
not supported. Images stored in an S3 Bucket do not need to be
base64-encoded.

If you are using an AWS SDK to call Amazon Rekognition, you might not
need to base64-encode image bytes passed using the \code{Bytes} field. For
more information, see Images in the Amazon Rekognition developer guide.}

\item{MaxLabels}{Maximum number of labels you want the service to return in the response.
The service returns the specified number of highest confidence labels.}

\item{MinConfidence}{Specifies the minimum confidence level for the labels to return. Amazon
Rekognition doesn't return any labels with confidence lower than this
specified value.

If \code{MinConfidence} is not specified, the operation returns labels with a
confidence values greater than or equal to 55 percent.}
}
\value{
A list with the following syntax:\preformatted{list(
  Labels = list(
    list(
      Name = "string",
      Confidence = 123.0,
      Instances = list(
        list(
          BoundingBox = list(
            Width = 123.0,
            Height = 123.0,
            Left = 123.0,
            Top = 123.0
          ),
          Confidence = 123.0
        )
      ),
      Parents = list(
        list(
          Name = "string"
        )
      )
    )
  ),
  OrientationCorrection = "ROTATE_0"|"ROTATE_90"|"ROTATE_180"|"ROTATE_270",
  LabelModelVersion = "string"
)
}
}
\description{
Detects instances of real-world entities within an image (JPEG or PNG)
provided as input. This includes objects like flower, tree, and table;
events like wedding, graduation, and birthday party; and concepts like
landscape, evening, and nature.

For an example, see Analyzing Images Stored in an Amazon S3 Bucket in
the Amazon Rekognition Developer Guide.

\code{\link[=rekognition_detect_labels]{detect_labels}} does not support the
detection of activities. However, activity detection is supported for
label detection in videos. For more information, see StartLabelDetection
in the Amazon Rekognition Developer Guide.

You pass the input image as base64-encoded image bytes or as a reference
to an image in an Amazon S3 bucket. If you use the AWS CLI to call
Amazon Rekognition operations, passing image bytes is not supported. The
image must be either a PNG or JPEG formatted file.

For each object, scene, and concept the API returns one or more labels.
Each label provides the object name, and the level of confidence that
the image contains the object. For example, suppose the input image has
a lighthouse, the sea, and a rock. The response includes all three
labels, one for each object.

\verb{\{Name: lighthouse, Confidence: 98.4629\}}

\verb{\{Name: rock,Confidence: 79.2097\}}

\verb{ \{Name: sea,Confidence: 75.061\}}

In the preceding example, the operation returns one label for each of
the three objects. The operation can also return multiple labels for the
same object in the image. For example, if the input image shows a flower
(for example, a tulip), the operation might return the following three
labels.

\verb{\{Name: flower,Confidence: 99.0562\}}

\verb{\{Name: plant,Confidence: 99.0562\}}

\verb{\{Name: tulip,Confidence: 99.0562\}}

In this example, the detection algorithm more precisely identifies the
flower as a tulip.

In response, the API returns an array of labels. In addition, the
response also includes the orientation correction. Optionally, you can
specify \code{MinConfidence} to control the confidence threshold for the
labels returned. The default is 55\%. You can also add the \code{MaxLabels}
parameter to limit the number of labels returned.

If the object detected is a person, the operation doesn't provide the
same facial details that the \code{\link[=rekognition_detect_faces]{detect_faces}}
operation provides.

\code{\link[=rekognition_detect_labels]{detect_labels}} returns bounding boxes for
instances of common object labels in an array of Instance objects. An
\code{Instance} object contains a BoundingBox object, for the location of the
label on the image. It also includes the confidence by which the
bounding box was detected.

\code{\link[=rekognition_detect_labels]{detect_labels}} also returns a hierarchical
taxonomy of detected labels. For example, a detected car might be
assigned the label \emph{car}. The label \emph{car} has two parent labels:
\emph{Vehicle} (its parent) and \emph{Transportation} (its grandparent). The
response returns the entire list of ancestors for a label. Each ancestor
is a unique label in the response. In the previous example, \emph{Car},
\emph{Vehicle}, and \emph{Transportation} are returned as unique labels in the
response.

This is a stateless API operation. That is, the operation does not
persist any data.

This operation requires permissions to perform the
\code{rekognition:DetectLabels} action.
}
\section{Request syntax}{
\preformatted{svc$detect_labels(
  Image = list(
    Bytes = raw,
    S3Object = list(
      Bucket = "string",
      Name = "string",
      Version = "string"
    )
  ),
  MaxLabels = 123,
  MinConfidence = 123.0
)
}
}

\examples{
\dontrun{
# This operation detects labels in the supplied image
svc$detect_labels(
  Image = list(
    S3Object = list(
      Bucket = "mybucket",
      Name = "myphoto"
    )
  ),
  MaxLabels = 123L,
  MinConfidence = 70L
)
}

}
\keyword{internal}
