% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalize_operations.R
\name{personalize_list_schemas}
\alias{personalize_list_schemas}
\title{Returns the list of schemas associated with the account}
\usage{
personalize_list_schemas(nextToken, maxResults)
}
\arguments{
\item{nextToken}{A token returned from the previous call to
\code{\link[=personalize_list_schemas]{list_schemas}} for getting the next set of
schemas (if they exist).}

\item{maxResults}{The maximum number of schemas to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  schemas = list(
    list(
      name = "string",
      schemaArn = "string",
      creationDateTime = as.POSIXct(
        "2015-01-01"
      ),
      lastUpdatedDateTime = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  nextToken = "string"
)
}
}
\description{
Returns the list of schemas associated with the account. The response
provides the properties for each schema, including the Amazon Resource
Name (ARN). For more information on schemas, see
\code{\link[=personalize_create_schema]{create_schema}}.
}
\section{Request syntax}{
\preformatted{svc$list_schemas(
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
