% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_feature_group}
\alias{sagemaker_create_feature_group}
\title{Create a new FeatureGroup}
\usage{
sagemaker_create_feature_group(FeatureGroupName,
  RecordIdentifierFeatureName, EventTimeFeatureName, FeatureDefinitions,
  OnlineStoreConfig, OfflineStoreConfig, RoleArn, Description, Tags)
}
\arguments{
\item{FeatureGroupName}{[required] The name of the \code{FeatureGroup}. The name must be unique within an AWS
Region in an AWS account. The name:
\itemize{
\item Must start and end with an alphanumeric character.
\item Can only contain alphanumeric character and hyphens. Spaces are not
allowed.
}}

\item{RecordIdentifierFeatureName}{[required] The name of the \code{Feature} whose value uniquely identifies a \code{Record}
defined in the \code{FeatureStore}. Only the latest record per identifier
value will be stored in the \code{OnlineStore}. \code{RecordIdentifierFeatureName}
must be one of feature definitions' names.

You use the \code{RecordIdentifierFeatureName} to access data in a
\code{FeatureStore}.

This name:
\itemize{
\item Must start and end with an alphanumeric character.
\item Can only contains alphanumeric characters, hyphens, underscores.
Spaces are not allowed.
}}

\item{EventTimeFeatureName}{[required] The name of the feature that stores the \code{EventTime} of a \code{Record} in a
\code{FeatureGroup}.

An \code{EventTime} is a point in time when a new event occurs that
corresponds to the creation or update of a \code{Record} in a \code{FeatureGroup}.
All \code{Records} in the \code{FeatureGroup} must have a corresponding
\code{EventTime}.

An \code{EventTime} can be a \code{String} or \code{Fractional}.
\itemize{
\item \code{Fractional}: \code{EventTime} feature values must be a Unix timestamp in
seconds.
\item \code{String}: \code{EventTime} feature values must be an ISO-8601 string in
the format. The following formats are supported
\verb{yyyy-MM-dd'T'HH:mm:ssZ} and \verb{yyyy-MM-dd'T'HH:mm:ss.SSSZ} where
\code{yyyy}, \code{MM}, and \code{dd} represent the year, month, and day
respectively and \code{HH}, \code{mm}, \code{ss}, and if applicable, \code{SSS}
represent the hour, month, second and milliseconds respsectively.
\code{'T'} and \code{Z} are constants.
}}

\item{FeatureDefinitions}{[required] A list of \code{Feature} names and types. \code{Name} and \code{Type} is compulsory per
\code{Feature}.

Valid feature \code{FeatureType}s are \code{Integral}, \code{Fractional} and \code{String}.

\code{FeatureName}s cannot be any of the following: \code{is_deleted},
\code{write_time}, \code{api_invocation_time}

You can create up to 2,500 \code{FeatureDefinition}s per \code{FeatureGroup}.}

\item{OnlineStoreConfig}{You can turn the \code{OnlineStore} on or off by specifying \code{True} for the
\code{EnableOnlineStore} flag in \code{OnlineStoreConfig}; the default value is
\code{False}.

You can also include an AWS KMS key ID (\code{KMSKeyId}) for at-rest
encryption of the \code{OnlineStore}.}

\item{OfflineStoreConfig}{Use this to configure an \code{OfflineFeatureStore}. This parameter allows
you to specify:
\itemize{
\item The Amazon Simple Storage Service (Amazon S3) location of an
\code{OfflineStore}.
\item A configuration for an AWS Glue or AWS Hive data cataolgue.
\item An KMS encryption key to encrypt the Amazon S3 location used for
\code{OfflineStore}.
}

To learn more about this parameter, see OfflineStoreConfig.}

\item{RoleArn}{The Amazon Resource Name (ARN) of the IAM execution role used to persist
data into the \code{OfflineStore} if an \code{OfflineStoreConfig} is provided.}

\item{Description}{A free-form description of a \code{FeatureGroup}.}

\item{Tags}{Tags used to identify \code{Features} in each \code{FeatureGroup}.}
}
\description{
Create a new \code{FeatureGroup}. A \code{FeatureGroup} is a group of \code{Features}
defined in the \code{FeatureStore} to describe a \code{Record}.

The \code{FeatureGroup} defines the schema and features contained in the
FeatureGroup. A \code{FeatureGroup} definition is composed of a list of
\code{Features}, a \code{RecordIdentifierFeatureName}, an \code{EventTimeFeatureName}
and configurations for its \code{OnlineStore} and \code{OfflineStore}. Check \href{https://docs.aws.amazon.com/general/latest/gr/aws_service_limits.html}{AWS service quotas}
to see the \code{FeatureGroup}s quota for your AWS account.

You must include at least one of \code{OnlineStoreConfig} and
\code{OfflineStoreConfig} to create a \code{FeatureGroup}.
}
\section{Request syntax}{
\preformatted{svc$create_feature_group(
  FeatureGroupName = "string",
  RecordIdentifierFeatureName = "string",
  EventTimeFeatureName = "string",
  FeatureDefinitions = list(
    list(
      FeatureName = "string",
      FeatureType = "Integral"|"Fractional"|"String"
    )
  ),
  OnlineStoreConfig = list(
    SecurityConfig = list(
      KmsKeyId = "string"
    ),
    EnableOnlineStore = TRUE|FALSE
  ),
  OfflineStoreConfig = list(
    S3StorageConfig = list(
      S3Uri = "string",
      KmsKeyId = "string"
    ),
    DisableGlueTableCreation = TRUE|FALSE,
    DataCatalogConfig = list(
      TableName = "string",
      Catalog = "string",
      Database = "string"
    )
  ),
  RoleArn = "string",
  Description = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
