% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspacesweb_operations.R
\name{workspacesweb_create_ip_access_settings}
\alias{workspacesweb_create_ip_access_settings}
\title{Creates an IP access settings resource that can be associated with a web
portal}
\usage{
workspacesweb_create_ip_access_settings(
  additionalEncryptionContext = NULL,
  clientToken = NULL,
  customerManagedKey = NULL,
  description = NULL,
  displayName = NULL,
  ipRules,
  tags = NULL
)
}
\arguments{
\item{additionalEncryptionContext}{Additional encryption context of the IP access settings.}

\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Idempotency ensures that an API request
completes only once. With an idempotent request, if the original request
completes successfully, subsequent retries with the same client token
returns the result from the original successful request.

If you do not specify a client token, one is automatically generated by
the AWS SDK.}

\item{customerManagedKey}{The custom managed key of the IP access settings.}

\item{description}{The description of the IP access settings.}

\item{displayName}{The display name of the IP access settings.}

\item{ipRules}{[required] The IP rules of the IP access settings.}

\item{tags}{The tags to add to the browser settings resource. A tag is a key-value
pair.}
}
\description{
Creates an IP access settings resource that can be associated with a web portal.

See \url{https://www.paws-r-sdk.com/docs/workspacesweb_create_ip_access_settings/} for full documentation.
}
\keyword{internal}
