# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include workdocs_service.R
NULL

#' Aborts the upload of the specified document version that was previously
#' initiated by InitiateDocumentVersionUpload
#'
#' @description
#' Aborts the upload of the specified document version that was previously initiated by [`initiate_document_version_upload`][workdocs_initiate_document_version_upload]. The client should make this call only when it no longer intends to upload the document version, or fails to do so.
#'
#' See [https://paws-r.github.io/docs/workdocs/abort_document_version_upload.html](https://paws-r.github.io/docs/workdocs/abort_document_version_upload.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param DocumentId &#91;required&#93; The ID of the document.
#' @param VersionId &#91;required&#93; The ID of the version.
#'
#' @keywords internal
#'
#' @rdname workdocs_abort_document_version_upload
workdocs_abort_document_version_upload <- function(AuthenticationToken = NULL, DocumentId, VersionId) {
  op <- new_operation(
    name = "AbortDocumentVersionUpload",
    http_method = "DELETE",
    http_path = "/api/v1/documents/{DocumentId}/versions/{VersionId}",
    paginator = list()
  )
  input <- .workdocs$abort_document_version_upload_input(AuthenticationToken = AuthenticationToken, DocumentId = DocumentId, VersionId = VersionId)
  output <- .workdocs$abort_document_version_upload_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$abort_document_version_upload <- workdocs_abort_document_version_upload

#' Activates the specified user
#'
#' @description
#' Activates the specified user. Only active users can access Amazon WorkDocs.
#'
#' See [https://paws-r.github.io/docs/workdocs/activate_user.html](https://paws-r.github.io/docs/workdocs/activate_user.html) for full documentation.
#'
#' @param UserId &#91;required&#93; The ID of the user.
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#'
#' @keywords internal
#'
#' @rdname workdocs_activate_user
workdocs_activate_user <- function(UserId, AuthenticationToken = NULL) {
  op <- new_operation(
    name = "ActivateUser",
    http_method = "POST",
    http_path = "/api/v1/users/{UserId}/activation",
    paginator = list()
  )
  input <- .workdocs$activate_user_input(UserId = UserId, AuthenticationToken = AuthenticationToken)
  output <- .workdocs$activate_user_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$activate_user <- workdocs_activate_user

#' Creates a set of permissions for the specified folder or document
#'
#' @description
#' Creates a set of permissions for the specified folder or document. The resource permissions are overwritten if the principals already have different permissions.
#'
#' See [https://paws-r.github.io/docs/workdocs/add_resource_permissions.html](https://paws-r.github.io/docs/workdocs/add_resource_permissions.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param ResourceId &#91;required&#93; The ID of the resource.
#' @param Principals &#91;required&#93; The users, groups, or organization being granted permission.
#' @param NotificationOptions The notification options.
#'
#' @keywords internal
#'
#' @rdname workdocs_add_resource_permissions
workdocs_add_resource_permissions <- function(AuthenticationToken = NULL, ResourceId, Principals, NotificationOptions = NULL) {
  op <- new_operation(
    name = "AddResourcePermissions",
    http_method = "POST",
    http_path = "/api/v1/resources/{ResourceId}/permissions",
    paginator = list()
  )
  input <- .workdocs$add_resource_permissions_input(AuthenticationToken = AuthenticationToken, ResourceId = ResourceId, Principals = Principals, NotificationOptions = NotificationOptions)
  output <- .workdocs$add_resource_permissions_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$add_resource_permissions <- workdocs_add_resource_permissions

#' Adds a new comment to the specified document version
#'
#' @description
#' Adds a new comment to the specified document version.
#'
#' See [https://paws-r.github.io/docs/workdocs/create_comment.html](https://paws-r.github.io/docs/workdocs/create_comment.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param DocumentId &#91;required&#93; The ID of the document.
#' @param VersionId &#91;required&#93; The ID of the document version.
#' @param ParentId The ID of the parent comment.
#' @param ThreadId The ID of the root comment in the thread.
#' @param Text &#91;required&#93; The text of the comment.
#' @param Visibility The visibility of the comment. Options are either PRIVATE, where the
#' comment is visible only to the comment author and document owner and
#' co-owners, or PUBLIC, where the comment is visible to document owners,
#' co-owners, and contributors.
#' @param NotifyCollaborators Set this parameter to TRUE to send an email out to the document
#' collaborators after the comment is created.
#'
#' @keywords internal
#'
#' @rdname workdocs_create_comment
workdocs_create_comment <- function(AuthenticationToken = NULL, DocumentId, VersionId, ParentId = NULL, ThreadId = NULL, Text, Visibility = NULL, NotifyCollaborators = NULL) {
  op <- new_operation(
    name = "CreateComment",
    http_method = "POST",
    http_path = "/api/v1/documents/{DocumentId}/versions/{VersionId}/comment",
    paginator = list()
  )
  input <- .workdocs$create_comment_input(AuthenticationToken = AuthenticationToken, DocumentId = DocumentId, VersionId = VersionId, ParentId = ParentId, ThreadId = ThreadId, Text = Text, Visibility = Visibility, NotifyCollaborators = NotifyCollaborators)
  output <- .workdocs$create_comment_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$create_comment <- workdocs_create_comment

#' Adds one or more custom properties to the specified resource (a folder,
#' document, or version)
#'
#' @description
#' Adds one or more custom properties to the specified resource (a folder, document, or version).
#'
#' See [https://paws-r.github.io/docs/workdocs/create_custom_metadata.html](https://paws-r.github.io/docs/workdocs/create_custom_metadata.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param ResourceId &#91;required&#93; The ID of the resource.
#' @param VersionId The ID of the version, if the custom metadata is being added to a
#' document version.
#' @param CustomMetadata &#91;required&#93; Custom metadata in the form of name-value pairs.
#'
#' @keywords internal
#'
#' @rdname workdocs_create_custom_metadata
workdocs_create_custom_metadata <- function(AuthenticationToken = NULL, ResourceId, VersionId = NULL, CustomMetadata) {
  op <- new_operation(
    name = "CreateCustomMetadata",
    http_method = "PUT",
    http_path = "/api/v1/resources/{ResourceId}/customMetadata",
    paginator = list()
  )
  input <- .workdocs$create_custom_metadata_input(AuthenticationToken = AuthenticationToken, ResourceId = ResourceId, VersionId = VersionId, CustomMetadata = CustomMetadata)
  output <- .workdocs$create_custom_metadata_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$create_custom_metadata <- workdocs_create_custom_metadata

#' Creates a folder with the specified name and parent folder
#'
#' @description
#' Creates a folder with the specified name and parent folder.
#'
#' See [https://paws-r.github.io/docs/workdocs/create_folder.html](https://paws-r.github.io/docs/workdocs/create_folder.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param Name The name of the new folder.
#' @param ParentFolderId &#91;required&#93; The ID of the parent folder.
#'
#' @keywords internal
#'
#' @rdname workdocs_create_folder
workdocs_create_folder <- function(AuthenticationToken = NULL, Name = NULL, ParentFolderId) {
  op <- new_operation(
    name = "CreateFolder",
    http_method = "POST",
    http_path = "/api/v1/folders",
    paginator = list()
  )
  input <- .workdocs$create_folder_input(AuthenticationToken = AuthenticationToken, Name = Name, ParentFolderId = ParentFolderId)
  output <- .workdocs$create_folder_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$create_folder <- workdocs_create_folder

#' Adds the specified list of labels to the given resource (a document or
#' folder)
#'
#' @description
#' Adds the specified list of labels to the given resource (a document or folder)
#'
#' See [https://paws-r.github.io/docs/workdocs/create_labels.html](https://paws-r.github.io/docs/workdocs/create_labels.html) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The ID of the resource.
#' @param Labels &#91;required&#93; List of labels to add to the resource.
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#'
#' @keywords internal
#'
#' @rdname workdocs_create_labels
workdocs_create_labels <- function(ResourceId, Labels, AuthenticationToken = NULL) {
  op <- new_operation(
    name = "CreateLabels",
    http_method = "PUT",
    http_path = "/api/v1/resources/{ResourceId}/labels",
    paginator = list()
  )
  input <- .workdocs$create_labels_input(ResourceId = ResourceId, Labels = Labels, AuthenticationToken = AuthenticationToken)
  output <- .workdocs$create_labels_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$create_labels <- workdocs_create_labels

#' Configure Amazon WorkDocs to use Amazon SNS notifications
#'
#' @description
#' Configure Amazon WorkDocs to use Amazon SNS notifications. The endpoint receives a confirmation message, and must confirm the subscription.
#'
#' See [https://paws-r.github.io/docs/workdocs/create_notification_subscription.html](https://paws-r.github.io/docs/workdocs/create_notification_subscription.html) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The ID of the organization.
#' @param Endpoint &#91;required&#93; The endpoint to receive the notifications. If the protocol is HTTPS, the
#' endpoint is a URL that begins with `https`.
#' @param Protocol &#91;required&#93; The protocol to use. The supported value is https, which delivers
#' JSON-encoded messages using HTTPS POST.
#' @param SubscriptionType &#91;required&#93; The notification type.
#'
#' @keywords internal
#'
#' @rdname workdocs_create_notification_subscription
workdocs_create_notification_subscription <- function(OrganizationId, Endpoint, Protocol, SubscriptionType) {
  op <- new_operation(
    name = "CreateNotificationSubscription",
    http_method = "POST",
    http_path = "/api/v1/organizations/{OrganizationId}/subscriptions",
    paginator = list()
  )
  input <- .workdocs$create_notification_subscription_input(OrganizationId = OrganizationId, Endpoint = Endpoint, Protocol = Protocol, SubscriptionType = SubscriptionType)
  output <- .workdocs$create_notification_subscription_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$create_notification_subscription <- workdocs_create_notification_subscription

#' Creates a user in a Simple AD or Microsoft AD directory
#'
#' @description
#' Creates a user in a Simple AD or Microsoft AD directory. The status of a newly created user is "ACTIVE". New users can access Amazon WorkDocs.
#'
#' See [https://paws-r.github.io/docs/workdocs/create_user.html](https://paws-r.github.io/docs/workdocs/create_user.html) for full documentation.
#'
#' @param OrganizationId The ID of the organization.
#' @param Username &#91;required&#93; The login name of the user.
#' @param EmailAddress The email address of the user.
#' @param GivenName &#91;required&#93; The given name of the user.
#' @param Surname &#91;required&#93; The surname of the user.
#' @param Password &#91;required&#93; The password of the user.
#' @param TimeZoneId The time zone ID of the user.
#' @param StorageRule The amount of storage for the user.
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#'
#' @keywords internal
#'
#' @rdname workdocs_create_user
workdocs_create_user <- function(OrganizationId = NULL, Username, EmailAddress = NULL, GivenName, Surname, Password, TimeZoneId = NULL, StorageRule = NULL, AuthenticationToken = NULL) {
  op <- new_operation(
    name = "CreateUser",
    http_method = "POST",
    http_path = "/api/v1/users",
    paginator = list()
  )
  input <- .workdocs$create_user_input(OrganizationId = OrganizationId, Username = Username, EmailAddress = EmailAddress, GivenName = GivenName, Surname = Surname, Password = Password, TimeZoneId = TimeZoneId, StorageRule = StorageRule, AuthenticationToken = AuthenticationToken)
  output <- .workdocs$create_user_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$create_user <- workdocs_create_user

#' Deactivates the specified user, which revokes the user's access to
#' Amazon WorkDocs
#'
#' @description
#' Deactivates the specified user, which revokes the user's access to Amazon WorkDocs.
#'
#' See [https://paws-r.github.io/docs/workdocs/deactivate_user.html](https://paws-r.github.io/docs/workdocs/deactivate_user.html) for full documentation.
#'
#' @param UserId &#91;required&#93; The ID of the user.
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#'
#' @keywords internal
#'
#' @rdname workdocs_deactivate_user
workdocs_deactivate_user <- function(UserId, AuthenticationToken = NULL) {
  op <- new_operation(
    name = "DeactivateUser",
    http_method = "DELETE",
    http_path = "/api/v1/users/{UserId}/activation",
    paginator = list()
  )
  input <- .workdocs$deactivate_user_input(UserId = UserId, AuthenticationToken = AuthenticationToken)
  output <- .workdocs$deactivate_user_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$deactivate_user <- workdocs_deactivate_user

#' Deletes the specified comment from the document version
#'
#' @description
#' Deletes the specified comment from the document version.
#'
#' See [https://paws-r.github.io/docs/workdocs/delete_comment.html](https://paws-r.github.io/docs/workdocs/delete_comment.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param DocumentId &#91;required&#93; The ID of the document.
#' @param VersionId &#91;required&#93; The ID of the document version.
#' @param CommentId &#91;required&#93; The ID of the comment.
#'
#' @keywords internal
#'
#' @rdname workdocs_delete_comment
workdocs_delete_comment <- function(AuthenticationToken = NULL, DocumentId, VersionId, CommentId) {
  op <- new_operation(
    name = "DeleteComment",
    http_method = "DELETE",
    http_path = "/api/v1/documents/{DocumentId}/versions/{VersionId}/comment/{CommentId}",
    paginator = list()
  )
  input <- .workdocs$delete_comment_input(AuthenticationToken = AuthenticationToken, DocumentId = DocumentId, VersionId = VersionId, CommentId = CommentId)
  output <- .workdocs$delete_comment_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$delete_comment <- workdocs_delete_comment

#' Deletes custom metadata from the specified resource
#'
#' @description
#' Deletes custom metadata from the specified resource.
#'
#' See [https://paws-r.github.io/docs/workdocs/delete_custom_metadata.html](https://paws-r.github.io/docs/workdocs/delete_custom_metadata.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param ResourceId &#91;required&#93; The ID of the resource, either a document or folder.
#' @param VersionId The ID of the version, if the custom metadata is being deleted from a
#' document version.
#' @param Keys List of properties to remove.
#' @param DeleteAll Flag to indicate removal of all custom metadata properties from the
#' specified resource.
#'
#' @keywords internal
#'
#' @rdname workdocs_delete_custom_metadata
workdocs_delete_custom_metadata <- function(AuthenticationToken = NULL, ResourceId, VersionId = NULL, Keys = NULL, DeleteAll = NULL) {
  op <- new_operation(
    name = "DeleteCustomMetadata",
    http_method = "DELETE",
    http_path = "/api/v1/resources/{ResourceId}/customMetadata",
    paginator = list()
  )
  input <- .workdocs$delete_custom_metadata_input(AuthenticationToken = AuthenticationToken, ResourceId = ResourceId, VersionId = VersionId, Keys = Keys, DeleteAll = DeleteAll)
  output <- .workdocs$delete_custom_metadata_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$delete_custom_metadata <- workdocs_delete_custom_metadata

#' Permanently deletes the specified document and its associated metadata
#'
#' @description
#' Permanently deletes the specified document and its associated metadata.
#'
#' See [https://paws-r.github.io/docs/workdocs/delete_document.html](https://paws-r.github.io/docs/workdocs/delete_document.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param DocumentId &#91;required&#93; The ID of the document.
#'
#' @keywords internal
#'
#' @rdname workdocs_delete_document
workdocs_delete_document <- function(AuthenticationToken = NULL, DocumentId) {
  op <- new_operation(
    name = "DeleteDocument",
    http_method = "DELETE",
    http_path = "/api/v1/documents/{DocumentId}",
    paginator = list()
  )
  input <- .workdocs$delete_document_input(AuthenticationToken = AuthenticationToken, DocumentId = DocumentId)
  output <- .workdocs$delete_document_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$delete_document <- workdocs_delete_document

#' Permanently deletes the specified folder and its contents
#'
#' @description
#' Permanently deletes the specified folder and its contents.
#'
#' See [https://paws-r.github.io/docs/workdocs/delete_folder.html](https://paws-r.github.io/docs/workdocs/delete_folder.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param FolderId &#91;required&#93; The ID of the folder.
#'
#' @keywords internal
#'
#' @rdname workdocs_delete_folder
workdocs_delete_folder <- function(AuthenticationToken = NULL, FolderId) {
  op <- new_operation(
    name = "DeleteFolder",
    http_method = "DELETE",
    http_path = "/api/v1/folders/{FolderId}",
    paginator = list()
  )
  input <- .workdocs$delete_folder_input(AuthenticationToken = AuthenticationToken, FolderId = FolderId)
  output <- .workdocs$delete_folder_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$delete_folder <- workdocs_delete_folder

#' Deletes the contents of the specified folder
#'
#' @description
#' Deletes the contents of the specified folder.
#'
#' See [https://paws-r.github.io/docs/workdocs/delete_folder_contents.html](https://paws-r.github.io/docs/workdocs/delete_folder_contents.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param FolderId &#91;required&#93; The ID of the folder.
#'
#' @keywords internal
#'
#' @rdname workdocs_delete_folder_contents
workdocs_delete_folder_contents <- function(AuthenticationToken = NULL, FolderId) {
  op <- new_operation(
    name = "DeleteFolderContents",
    http_method = "DELETE",
    http_path = "/api/v1/folders/{FolderId}/contents",
    paginator = list()
  )
  input <- .workdocs$delete_folder_contents_input(AuthenticationToken = AuthenticationToken, FolderId = FolderId)
  output <- .workdocs$delete_folder_contents_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$delete_folder_contents <- workdocs_delete_folder_contents

#' Deletes the specified list of labels from a resource
#'
#' @description
#' Deletes the specified list of labels from a resource.
#'
#' See [https://paws-r.github.io/docs/workdocs/delete_labels.html](https://paws-r.github.io/docs/workdocs/delete_labels.html) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The ID of the resource.
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param Labels List of labels to delete from the resource.
#' @param DeleteAll Flag to request removal of all labels from the specified resource.
#'
#' @keywords internal
#'
#' @rdname workdocs_delete_labels
workdocs_delete_labels <- function(ResourceId, AuthenticationToken = NULL, Labels = NULL, DeleteAll = NULL) {
  op <- new_operation(
    name = "DeleteLabels",
    http_method = "DELETE",
    http_path = "/api/v1/resources/{ResourceId}/labels",
    paginator = list()
  )
  input <- .workdocs$delete_labels_input(ResourceId = ResourceId, AuthenticationToken = AuthenticationToken, Labels = Labels, DeleteAll = DeleteAll)
  output <- .workdocs$delete_labels_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$delete_labels <- workdocs_delete_labels

#' Deletes the specified subscription from the specified organization
#'
#' @description
#' Deletes the specified subscription from the specified organization.
#'
#' See [https://paws-r.github.io/docs/workdocs/delete_notification_subscription.html](https://paws-r.github.io/docs/workdocs/delete_notification_subscription.html) for full documentation.
#'
#' @param SubscriptionId &#91;required&#93; The ID of the subscription.
#' @param OrganizationId &#91;required&#93; The ID of the organization.
#'
#' @keywords internal
#'
#' @rdname workdocs_delete_notification_subscription
workdocs_delete_notification_subscription <- function(SubscriptionId, OrganizationId) {
  op <- new_operation(
    name = "DeleteNotificationSubscription",
    http_method = "DELETE",
    http_path = "/api/v1/organizations/{OrganizationId}/subscriptions/{SubscriptionId}",
    paginator = list()
  )
  input <- .workdocs$delete_notification_subscription_input(SubscriptionId = SubscriptionId, OrganizationId = OrganizationId)
  output <- .workdocs$delete_notification_subscription_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$delete_notification_subscription <- workdocs_delete_notification_subscription

#' Deletes the specified user from a Simple AD or Microsoft AD directory
#'
#' @description
#' Deletes the specified user from a Simple AD or Microsoft AD directory.
#'
#' See [https://paws-r.github.io/docs/workdocs/delete_user.html](https://paws-r.github.io/docs/workdocs/delete_user.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Do not set this field when using
#' administrative API actions, as in accessing the API using AWS
#' credentials.
#' @param UserId &#91;required&#93; The ID of the user.
#'
#' @keywords internal
#'
#' @rdname workdocs_delete_user
workdocs_delete_user <- function(AuthenticationToken = NULL, UserId) {
  op <- new_operation(
    name = "DeleteUser",
    http_method = "DELETE",
    http_path = "/api/v1/users/{UserId}",
    paginator = list()
  )
  input <- .workdocs$delete_user_input(AuthenticationToken = AuthenticationToken, UserId = UserId)
  output <- .workdocs$delete_user_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$delete_user <- workdocs_delete_user

#' Describes the user activities in a specified time period
#'
#' @description
#' Describes the user activities in a specified time period.
#'
#' See [https://paws-r.github.io/docs/workdocs/describe_activities.html](https://paws-r.github.io/docs/workdocs/describe_activities.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param StartTime The timestamp that determines the starting time of the activities. The
#' response includes the activities performed after the specified
#' timestamp.
#' @param EndTime The timestamp that determines the end time of the activities. The
#' response includes the activities performed before the specified
#' timestamp.
#' @param OrganizationId The ID of the organization. This is a mandatory parameter when using
#' administrative API (SigV4) requests.
#' @param ActivityTypes Specifies which activity types to include in the response. If this field
#' is left empty, all activity types are returned.
#' @param ResourceId The document or folder ID for which to describe activity types.
#' @param UserId The ID of the user who performed the action. The response includes
#' activities pertaining to this user. This is an optional parameter and is
#' only applicable for administrative API (SigV4) requests.
#' @param IncludeIndirectActivities Includes indirect activities. An indirect activity results from a direct
#' activity performed on a parent resource. For example, sharing a parent
#' folder (the direct activity) shares all of the subfolders and documents
#' within the parent folder (the indirect activity).
#' @param Limit The maximum number of items to return.
#' @param Marker The marker for the next set of results.
#'
#' @keywords internal
#'
#' @rdname workdocs_describe_activities
workdocs_describe_activities <- function(AuthenticationToken = NULL, StartTime = NULL, EndTime = NULL, OrganizationId = NULL, ActivityTypes = NULL, ResourceId = NULL, UserId = NULL, IncludeIndirectActivities = NULL, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeActivities",
    http_method = "GET",
    http_path = "/api/v1/activities",
    paginator = list()
  )
  input <- .workdocs$describe_activities_input(AuthenticationToken = AuthenticationToken, StartTime = StartTime, EndTime = EndTime, OrganizationId = OrganizationId, ActivityTypes = ActivityTypes, ResourceId = ResourceId, UserId = UserId, IncludeIndirectActivities = IncludeIndirectActivities, Limit = Limit, Marker = Marker)
  output <- .workdocs$describe_activities_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$describe_activities <- workdocs_describe_activities

#' List all the comments for the specified document version
#'
#' @description
#' List all the comments for the specified document version.
#'
#' See [https://paws-r.github.io/docs/workdocs/describe_comments.html](https://paws-r.github.io/docs/workdocs/describe_comments.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param DocumentId &#91;required&#93; The ID of the document.
#' @param VersionId &#91;required&#93; The ID of the document version.
#' @param Limit The maximum number of items to return.
#' @param Marker The marker for the next set of results. This marker was received from a
#' previous call.
#'
#' @keywords internal
#'
#' @rdname workdocs_describe_comments
workdocs_describe_comments <- function(AuthenticationToken = NULL, DocumentId, VersionId, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeComments",
    http_method = "GET",
    http_path = "/api/v1/documents/{DocumentId}/versions/{VersionId}/comments",
    paginator = list()
  )
  input <- .workdocs$describe_comments_input(AuthenticationToken = AuthenticationToken, DocumentId = DocumentId, VersionId = VersionId, Limit = Limit, Marker = Marker)
  output <- .workdocs$describe_comments_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$describe_comments <- workdocs_describe_comments

#' Retrieves the document versions for the specified document
#'
#' @description
#' Retrieves the document versions for the specified document.
#'
#' See [https://paws-r.github.io/docs/workdocs/describe_document_versions.html](https://paws-r.github.io/docs/workdocs/describe_document_versions.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param DocumentId &#91;required&#93; The ID of the document.
#' @param Marker The marker for the next set of results. (You received this marker from a
#' previous call.)
#' @param Limit The maximum number of versions to return with this call.
#' @param Include A comma-separated list of values. Specify "INITIALIZED" to include
#' incomplete versions.
#' @param Fields Specify "SOURCE" to include initialized versions and a URL for the
#' source document.
#'
#' @keywords internal
#'
#' @rdname workdocs_describe_document_versions
workdocs_describe_document_versions <- function(AuthenticationToken = NULL, DocumentId, Marker = NULL, Limit = NULL, Include = NULL, Fields = NULL) {
  op <- new_operation(
    name = "DescribeDocumentVersions",
    http_method = "GET",
    http_path = "/api/v1/documents/{DocumentId}/versions",
    paginator = list()
  )
  input <- .workdocs$describe_document_versions_input(AuthenticationToken = AuthenticationToken, DocumentId = DocumentId, Marker = Marker, Limit = Limit, Include = Include, Fields = Fields)
  output <- .workdocs$describe_document_versions_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$describe_document_versions <- workdocs_describe_document_versions

#' Describes the contents of the specified folder, including its documents
#' and subfolders
#'
#' @description
#' Describes the contents of the specified folder, including its documents and subfolders.
#'
#' See [https://paws-r.github.io/docs/workdocs/describe_folder_contents.html](https://paws-r.github.io/docs/workdocs/describe_folder_contents.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param FolderId &#91;required&#93; The ID of the folder.
#' @param Sort The sorting criteria.
#' @param Order The order for the contents of the folder.
#' @param Limit The maximum number of items to return with this call.
#' @param Marker The marker for the next set of results. This marker was received from a
#' previous call.
#' @param Type The type of items.
#' @param Include The contents to include. Specify "INITIALIZED" to include initialized
#' documents.
#'
#' @keywords internal
#'
#' @rdname workdocs_describe_folder_contents
workdocs_describe_folder_contents <- function(AuthenticationToken = NULL, FolderId, Sort = NULL, Order = NULL, Limit = NULL, Marker = NULL, Type = NULL, Include = NULL) {
  op <- new_operation(
    name = "DescribeFolderContents",
    http_method = "GET",
    http_path = "/api/v1/folders/{FolderId}/contents",
    paginator = list()
  )
  input <- .workdocs$describe_folder_contents_input(AuthenticationToken = AuthenticationToken, FolderId = FolderId, Sort = Sort, Order = Order, Limit = Limit, Marker = Marker, Type = Type, Include = Include)
  output <- .workdocs$describe_folder_contents_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$describe_folder_contents <- workdocs_describe_folder_contents

#' Describes the groups specified by the query
#'
#' @description
#' Describes the groups specified by the query. Groups are defined by the underlying Active Directory.
#'
#' See [https://paws-r.github.io/docs/workdocs/describe_groups.html](https://paws-r.github.io/docs/workdocs/describe_groups.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param SearchQuery &#91;required&#93; A query to describe groups by group name.
#' @param OrganizationId The ID of the organization.
#' @param Marker The marker for the next set of results. (You received this marker from a
#' previous call.)
#' @param Limit The maximum number of items to return with this call.
#'
#' @keywords internal
#'
#' @rdname workdocs_describe_groups
workdocs_describe_groups <- function(AuthenticationToken = NULL, SearchQuery, OrganizationId = NULL, Marker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeGroups",
    http_method = "GET",
    http_path = "/api/v1/groups",
    paginator = list()
  )
  input <- .workdocs$describe_groups_input(AuthenticationToken = AuthenticationToken, SearchQuery = SearchQuery, OrganizationId = OrganizationId, Marker = Marker, Limit = Limit)
  output <- .workdocs$describe_groups_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$describe_groups <- workdocs_describe_groups

#' Lists the specified notification subscriptions
#'
#' @description
#' Lists the specified notification subscriptions.
#'
#' See [https://paws-r.github.io/docs/workdocs/describe_notification_subscriptions.html](https://paws-r.github.io/docs/workdocs/describe_notification_subscriptions.html) for full documentation.
#'
#' @param OrganizationId &#91;required&#93; The ID of the organization.
#' @param Marker The marker for the next set of results. (You received this marker from a
#' previous call.)
#' @param Limit The maximum number of items to return with this call.
#'
#' @keywords internal
#'
#' @rdname workdocs_describe_notification_subscriptions
workdocs_describe_notification_subscriptions <- function(OrganizationId, Marker = NULL, Limit = NULL) {
  op <- new_operation(
    name = "DescribeNotificationSubscriptions",
    http_method = "GET",
    http_path = "/api/v1/organizations/{OrganizationId}/subscriptions",
    paginator = list()
  )
  input <- .workdocs$describe_notification_subscriptions_input(OrganizationId = OrganizationId, Marker = Marker, Limit = Limit)
  output <- .workdocs$describe_notification_subscriptions_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$describe_notification_subscriptions <- workdocs_describe_notification_subscriptions

#' Describes the permissions of a specified resource
#'
#' @description
#' Describes the permissions of a specified resource.
#'
#' See [https://paws-r.github.io/docs/workdocs/describe_resource_permissions.html](https://paws-r.github.io/docs/workdocs/describe_resource_permissions.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param ResourceId &#91;required&#93; The ID of the resource.
#' @param PrincipalId The ID of the principal to filter permissions by.
#' @param Limit The maximum number of items to return with this call.
#' @param Marker The marker for the next set of results. (You received this marker from a
#' previous call)
#'
#' @keywords internal
#'
#' @rdname workdocs_describe_resource_permissions
workdocs_describe_resource_permissions <- function(AuthenticationToken = NULL, ResourceId, PrincipalId = NULL, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeResourcePermissions",
    http_method = "GET",
    http_path = "/api/v1/resources/{ResourceId}/permissions",
    paginator = list()
  )
  input <- .workdocs$describe_resource_permissions_input(AuthenticationToken = AuthenticationToken, ResourceId = ResourceId, PrincipalId = PrincipalId, Limit = Limit, Marker = Marker)
  output <- .workdocs$describe_resource_permissions_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$describe_resource_permissions <- workdocs_describe_resource_permissions

#' Describes the current user's special folders; the RootFolder and the
#' RecycleBin
#'
#' @description
#' Describes the current user's special folders; the `RootFolder` and the `RecycleBin`. `RootFolder` is the root of user's files and folders and `RecycleBin` is the root of recycled items. This is not a valid action for SigV4 (administrative API) clients.
#'
#' See [https://paws-r.github.io/docs/workdocs/describe_root_folders.html](https://paws-r.github.io/docs/workdocs/describe_root_folders.html) for full documentation.
#'
#' @param AuthenticationToken &#91;required&#93; Amazon WorkDocs authentication token.
#' @param Limit The maximum number of items to return.
#' @param Marker The marker for the next set of results. (You received this marker from a
#' previous call.)
#'
#' @keywords internal
#'
#' @rdname workdocs_describe_root_folders
workdocs_describe_root_folders <- function(AuthenticationToken, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "DescribeRootFolders",
    http_method = "GET",
    http_path = "/api/v1/me/root",
    paginator = list()
  )
  input <- .workdocs$describe_root_folders_input(AuthenticationToken = AuthenticationToken, Limit = Limit, Marker = Marker)
  output <- .workdocs$describe_root_folders_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$describe_root_folders <- workdocs_describe_root_folders

#' Describes the specified users
#'
#' @description
#' Describes the specified users. You can describe all users or filter the results (for example, by status or organization).
#'
#' See [https://paws-r.github.io/docs/workdocs/describe_users.html](https://paws-r.github.io/docs/workdocs/describe_users.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param OrganizationId The ID of the organization.
#' @param UserIds The IDs of the users.
#' @param Query A query to filter users by user name.
#' @param Include The state of the users. Specify "ALL" to include inactive users.
#' @param Order The order for the results.
#' @param Sort The sorting criteria.
#' @param Marker The marker for the next set of results. (You received this marker from a
#' previous call.)
#' @param Limit The maximum number of items to return.
#' @param Fields A comma-separated list of values. Specify "STORAGE_METADATA" to include
#' the user storage quota and utilization information.
#'
#' @keywords internal
#'
#' @rdname workdocs_describe_users
workdocs_describe_users <- function(AuthenticationToken = NULL, OrganizationId = NULL, UserIds = NULL, Query = NULL, Include = NULL, Order = NULL, Sort = NULL, Marker = NULL, Limit = NULL, Fields = NULL) {
  op <- new_operation(
    name = "DescribeUsers",
    http_method = "GET",
    http_path = "/api/v1/users",
    paginator = list()
  )
  input <- .workdocs$describe_users_input(AuthenticationToken = AuthenticationToken, OrganizationId = OrganizationId, UserIds = UserIds, Query = Query, Include = Include, Order = Order, Sort = Sort, Marker = Marker, Limit = Limit, Fields = Fields)
  output <- .workdocs$describe_users_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$describe_users <- workdocs_describe_users

#' Retrieves details of the current user for whom the authentication token
#' was generated
#'
#' @description
#' Retrieves details of the current user for whom the authentication token was generated. This is not a valid action for SigV4 (administrative API) clients.
#'
#' See [https://paws-r.github.io/docs/workdocs/get_current_user.html](https://paws-r.github.io/docs/workdocs/get_current_user.html) for full documentation.
#'
#' @param AuthenticationToken &#91;required&#93; Amazon WorkDocs authentication token.
#'
#' @keywords internal
#'
#' @rdname workdocs_get_current_user
workdocs_get_current_user <- function(AuthenticationToken) {
  op <- new_operation(
    name = "GetCurrentUser",
    http_method = "GET",
    http_path = "/api/v1/me",
    paginator = list()
  )
  input <- .workdocs$get_current_user_input(AuthenticationToken = AuthenticationToken)
  output <- .workdocs$get_current_user_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$get_current_user <- workdocs_get_current_user

#' Retrieves details of a document
#'
#' @description
#' Retrieves details of a document.
#'
#' See [https://paws-r.github.io/docs/workdocs/get_document.html](https://paws-r.github.io/docs/workdocs/get_document.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param DocumentId &#91;required&#93; The ID of the document.
#' @param IncludeCustomMetadata Set this to `TRUE` to include custom metadata in the response.
#'
#' @keywords internal
#'
#' @rdname workdocs_get_document
workdocs_get_document <- function(AuthenticationToken = NULL, DocumentId, IncludeCustomMetadata = NULL) {
  op <- new_operation(
    name = "GetDocument",
    http_method = "GET",
    http_path = "/api/v1/documents/{DocumentId}",
    paginator = list()
  )
  input <- .workdocs$get_document_input(AuthenticationToken = AuthenticationToken, DocumentId = DocumentId, IncludeCustomMetadata = IncludeCustomMetadata)
  output <- .workdocs$get_document_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$get_document <- workdocs_get_document

#' Retrieves the path information (the hierarchy from the root folder) for
#' the requested document
#'
#' @description
#' Retrieves the path information (the hierarchy from the root folder) for the requested document.
#'
#' See [https://paws-r.github.io/docs/workdocs/get_document_path.html](https://paws-r.github.io/docs/workdocs/get_document_path.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param DocumentId &#91;required&#93; The ID of the document.
#' @param Limit The maximum number of levels in the hierarchy to return.
#' @param Fields A comma-separated list of values. Specify `NAME` to include the names of
#' the parent folders.
#' @param Marker This value is not supported.
#'
#' @keywords internal
#'
#' @rdname workdocs_get_document_path
workdocs_get_document_path <- function(AuthenticationToken = NULL, DocumentId, Limit = NULL, Fields = NULL, Marker = NULL) {
  op <- new_operation(
    name = "GetDocumentPath",
    http_method = "GET",
    http_path = "/api/v1/documents/{DocumentId}/path",
    paginator = list()
  )
  input <- .workdocs$get_document_path_input(AuthenticationToken = AuthenticationToken, DocumentId = DocumentId, Limit = Limit, Fields = Fields, Marker = Marker)
  output <- .workdocs$get_document_path_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$get_document_path <- workdocs_get_document_path

#' Retrieves version metadata for the specified document
#'
#' @description
#' Retrieves version metadata for the specified document.
#'
#' See [https://paws-r.github.io/docs/workdocs/get_document_version.html](https://paws-r.github.io/docs/workdocs/get_document_version.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param DocumentId &#91;required&#93; The ID of the document.
#' @param VersionId &#91;required&#93; The version ID of the document.
#' @param Fields A comma-separated list of values. Specify "SOURCE" to include a URL for
#' the source document.
#' @param IncludeCustomMetadata Set this to TRUE to include custom metadata in the response.
#'
#' @keywords internal
#'
#' @rdname workdocs_get_document_version
workdocs_get_document_version <- function(AuthenticationToken = NULL, DocumentId, VersionId, Fields = NULL, IncludeCustomMetadata = NULL) {
  op <- new_operation(
    name = "GetDocumentVersion",
    http_method = "GET",
    http_path = "/api/v1/documents/{DocumentId}/versions/{VersionId}",
    paginator = list()
  )
  input <- .workdocs$get_document_version_input(AuthenticationToken = AuthenticationToken, DocumentId = DocumentId, VersionId = VersionId, Fields = Fields, IncludeCustomMetadata = IncludeCustomMetadata)
  output <- .workdocs$get_document_version_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$get_document_version <- workdocs_get_document_version

#' Retrieves the metadata of the specified folder
#'
#' @description
#' Retrieves the metadata of the specified folder.
#'
#' See [https://paws-r.github.io/docs/workdocs/get_folder.html](https://paws-r.github.io/docs/workdocs/get_folder.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param FolderId &#91;required&#93; The ID of the folder.
#' @param IncludeCustomMetadata Set to TRUE to include custom metadata in the response.
#'
#' @keywords internal
#'
#' @rdname workdocs_get_folder
workdocs_get_folder <- function(AuthenticationToken = NULL, FolderId, IncludeCustomMetadata = NULL) {
  op <- new_operation(
    name = "GetFolder",
    http_method = "GET",
    http_path = "/api/v1/folders/{FolderId}",
    paginator = list()
  )
  input <- .workdocs$get_folder_input(AuthenticationToken = AuthenticationToken, FolderId = FolderId, IncludeCustomMetadata = IncludeCustomMetadata)
  output <- .workdocs$get_folder_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$get_folder <- workdocs_get_folder

#' Retrieves the path information (the hierarchy from the root folder) for
#' the specified folder
#'
#' @description
#' Retrieves the path information (the hierarchy from the root folder) for the specified folder.
#'
#' See [https://paws-r.github.io/docs/workdocs/get_folder_path.html](https://paws-r.github.io/docs/workdocs/get_folder_path.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param FolderId &#91;required&#93; The ID of the folder.
#' @param Limit The maximum number of levels in the hierarchy to return.
#' @param Fields A comma-separated list of values. Specify "NAME" to include the names of
#' the parent folders.
#' @param Marker This value is not supported.
#'
#' @keywords internal
#'
#' @rdname workdocs_get_folder_path
workdocs_get_folder_path <- function(AuthenticationToken = NULL, FolderId, Limit = NULL, Fields = NULL, Marker = NULL) {
  op <- new_operation(
    name = "GetFolderPath",
    http_method = "GET",
    http_path = "/api/v1/folders/{FolderId}/path",
    paginator = list()
  )
  input <- .workdocs$get_folder_path_input(AuthenticationToken = AuthenticationToken, FolderId = FolderId, Limit = Limit, Fields = Fields, Marker = Marker)
  output <- .workdocs$get_folder_path_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$get_folder_path <- workdocs_get_folder_path

#' Retrieves a collection of resources, including folders and documents
#'
#' @description
#' Retrieves a collection of resources, including folders and documents. The only `CollectionType` supported is `SHARED_WITH_ME`.
#'
#' See [https://paws-r.github.io/docs/workdocs/get_resources.html](https://paws-r.github.io/docs/workdocs/get_resources.html) for full documentation.
#'
#' @param AuthenticationToken The Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param UserId The user ID for the resource collection. This is a required field for
#' accessing the API operation using IAM credentials.
#' @param CollectionType The collection type.
#' @param Limit The maximum number of resources to return.
#' @param Marker The marker for the next set of results. This marker was received from a
#' previous call.
#'
#' @keywords internal
#'
#' @rdname workdocs_get_resources
workdocs_get_resources <- function(AuthenticationToken = NULL, UserId = NULL, CollectionType = NULL, Limit = NULL, Marker = NULL) {
  op <- new_operation(
    name = "GetResources",
    http_method = "GET",
    http_path = "/api/v1/resources",
    paginator = list()
  )
  input <- .workdocs$get_resources_input(AuthenticationToken = AuthenticationToken, UserId = UserId, CollectionType = CollectionType, Limit = Limit, Marker = Marker)
  output <- .workdocs$get_resources_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$get_resources <- workdocs_get_resources

#' Creates a new document object and version object
#'
#' @description
#' Creates a new document object and version object.
#'
#' See [https://paws-r.github.io/docs/workdocs/initiate_document_version_upload.html](https://paws-r.github.io/docs/workdocs/initiate_document_version_upload.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param Id The ID of the document.
#' @param Name The name of the document.
#' @param ContentCreatedTimestamp The timestamp when the content of the document was originally created.
#' @param ContentModifiedTimestamp The timestamp when the content of the document was modified.
#' @param ContentType The content type of the document.
#' @param DocumentSizeInBytes The size of the document, in bytes.
#' @param ParentFolderId &#91;required&#93; The ID of the parent folder.
#'
#' @keywords internal
#'
#' @rdname workdocs_initiate_document_version_upload
workdocs_initiate_document_version_upload <- function(AuthenticationToken = NULL, Id = NULL, Name = NULL, ContentCreatedTimestamp = NULL, ContentModifiedTimestamp = NULL, ContentType = NULL, DocumentSizeInBytes = NULL, ParentFolderId) {
  op <- new_operation(
    name = "InitiateDocumentVersionUpload",
    http_method = "POST",
    http_path = "/api/v1/documents",
    paginator = list()
  )
  input <- .workdocs$initiate_document_version_upload_input(AuthenticationToken = AuthenticationToken, Id = Id, Name = Name, ContentCreatedTimestamp = ContentCreatedTimestamp, ContentModifiedTimestamp = ContentModifiedTimestamp, ContentType = ContentType, DocumentSizeInBytes = DocumentSizeInBytes, ParentFolderId = ParentFolderId)
  output <- .workdocs$initiate_document_version_upload_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$initiate_document_version_upload <- workdocs_initiate_document_version_upload

#' Removes all the permissions from the specified resource
#'
#' @description
#' Removes all the permissions from the specified resource.
#'
#' See [https://paws-r.github.io/docs/workdocs/remove_all_resource_permissions.html](https://paws-r.github.io/docs/workdocs/remove_all_resource_permissions.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param ResourceId &#91;required&#93; The ID of the resource.
#'
#' @keywords internal
#'
#' @rdname workdocs_remove_all_resource_permissions
workdocs_remove_all_resource_permissions <- function(AuthenticationToken = NULL, ResourceId) {
  op <- new_operation(
    name = "RemoveAllResourcePermissions",
    http_method = "DELETE",
    http_path = "/api/v1/resources/{ResourceId}/permissions",
    paginator = list()
  )
  input <- .workdocs$remove_all_resource_permissions_input(AuthenticationToken = AuthenticationToken, ResourceId = ResourceId)
  output <- .workdocs$remove_all_resource_permissions_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$remove_all_resource_permissions <- workdocs_remove_all_resource_permissions

#' Removes the permission for the specified principal from the specified
#' resource
#'
#' @description
#' Removes the permission for the specified principal from the specified resource.
#'
#' See [https://paws-r.github.io/docs/workdocs/remove_resource_permission.html](https://paws-r.github.io/docs/workdocs/remove_resource_permission.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param ResourceId &#91;required&#93; The ID of the resource.
#' @param PrincipalId &#91;required&#93; The principal ID of the resource.
#' @param PrincipalType The principal type of the resource.
#'
#' @keywords internal
#'
#' @rdname workdocs_remove_resource_permission
workdocs_remove_resource_permission <- function(AuthenticationToken = NULL, ResourceId, PrincipalId, PrincipalType = NULL) {
  op <- new_operation(
    name = "RemoveResourcePermission",
    http_method = "DELETE",
    http_path = "/api/v1/resources/{ResourceId}/permissions/{PrincipalId}",
    paginator = list()
  )
  input <- .workdocs$remove_resource_permission_input(AuthenticationToken = AuthenticationToken, ResourceId = ResourceId, PrincipalId = PrincipalId, PrincipalType = PrincipalType)
  output <- .workdocs$remove_resource_permission_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$remove_resource_permission <- workdocs_remove_resource_permission

#' Updates the specified attributes of a document
#'
#' @description
#' Updates the specified attributes of a document. The user must have access to both the document and its parent folder, if applicable.
#'
#' See [https://paws-r.github.io/docs/workdocs/update_document.html](https://paws-r.github.io/docs/workdocs/update_document.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param DocumentId &#91;required&#93; The ID of the document.
#' @param Name The name of the document.
#' @param ParentFolderId The ID of the parent folder.
#' @param ResourceState The resource state of the document. Only ACTIVE and RECYCLED are
#' supported.
#'
#' @keywords internal
#'
#' @rdname workdocs_update_document
workdocs_update_document <- function(AuthenticationToken = NULL, DocumentId, Name = NULL, ParentFolderId = NULL, ResourceState = NULL) {
  op <- new_operation(
    name = "UpdateDocument",
    http_method = "PATCH",
    http_path = "/api/v1/documents/{DocumentId}",
    paginator = list()
  )
  input <- .workdocs$update_document_input(AuthenticationToken = AuthenticationToken, DocumentId = DocumentId, Name = Name, ParentFolderId = ParentFolderId, ResourceState = ResourceState)
  output <- .workdocs$update_document_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$update_document <- workdocs_update_document

#' Changes the status of the document version to ACTIVE
#'
#' @description
#' Changes the status of the document version to ACTIVE.
#'
#' See [https://paws-r.github.io/docs/workdocs/update_document_version.html](https://paws-r.github.io/docs/workdocs/update_document_version.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param DocumentId &#91;required&#93; The ID of the document.
#' @param VersionId &#91;required&#93; The version ID of the document.
#' @param VersionStatus The status of the version.
#'
#' @keywords internal
#'
#' @rdname workdocs_update_document_version
workdocs_update_document_version <- function(AuthenticationToken = NULL, DocumentId, VersionId, VersionStatus = NULL) {
  op <- new_operation(
    name = "UpdateDocumentVersion",
    http_method = "PATCH",
    http_path = "/api/v1/documents/{DocumentId}/versions/{VersionId}",
    paginator = list()
  )
  input <- .workdocs$update_document_version_input(AuthenticationToken = AuthenticationToken, DocumentId = DocumentId, VersionId = VersionId, VersionStatus = VersionStatus)
  output <- .workdocs$update_document_version_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$update_document_version <- workdocs_update_document_version

#' Updates the specified attributes of the specified folder
#'
#' @description
#' Updates the specified attributes of the specified folder. The user must have access to both the folder and its parent folder, if applicable.
#'
#' See [https://paws-r.github.io/docs/workdocs/update_folder.html](https://paws-r.github.io/docs/workdocs/update_folder.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param FolderId &#91;required&#93; The ID of the folder.
#' @param Name The name of the folder.
#' @param ParentFolderId The ID of the parent folder.
#' @param ResourceState The resource state of the folder. Only ACTIVE and RECYCLED are accepted
#' values from the API.
#'
#' @keywords internal
#'
#' @rdname workdocs_update_folder
workdocs_update_folder <- function(AuthenticationToken = NULL, FolderId, Name = NULL, ParentFolderId = NULL, ResourceState = NULL) {
  op <- new_operation(
    name = "UpdateFolder",
    http_method = "PATCH",
    http_path = "/api/v1/folders/{FolderId}",
    paginator = list()
  )
  input <- .workdocs$update_folder_input(AuthenticationToken = AuthenticationToken, FolderId = FolderId, Name = Name, ParentFolderId = ParentFolderId, ResourceState = ResourceState)
  output <- .workdocs$update_folder_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$update_folder <- workdocs_update_folder

#' Updates the specified attributes of the specified user, and grants or
#' revokes administrative privileges to the Amazon WorkDocs site
#'
#' @description
#' Updates the specified attributes of the specified user, and grants or revokes administrative privileges to the Amazon WorkDocs site.
#'
#' See [https://paws-r.github.io/docs/workdocs/update_user.html](https://paws-r.github.io/docs/workdocs/update_user.html) for full documentation.
#'
#' @param AuthenticationToken Amazon WorkDocs authentication token. Not required when using AWS
#' administrator credentials to access the API.
#' @param UserId &#91;required&#93; The ID of the user.
#' @param GivenName The given name of the user.
#' @param Surname The surname of the user.
#' @param Type The type of the user.
#' @param StorageRule The amount of storage for the user.
#' @param TimeZoneId The time zone ID of the user.
#' @param Locale The locale of the user.
#' @param GrantPoweruserPrivileges Boolean value to determine whether the user is granted Poweruser
#' privileges.
#'
#' @keywords internal
#'
#' @rdname workdocs_update_user
workdocs_update_user <- function(AuthenticationToken = NULL, UserId, GivenName = NULL, Surname = NULL, Type = NULL, StorageRule = NULL, TimeZoneId = NULL, Locale = NULL, GrantPoweruserPrivileges = NULL) {
  op <- new_operation(
    name = "UpdateUser",
    http_method = "PATCH",
    http_path = "/api/v1/users/{UserId}",
    paginator = list()
  )
  input <- .workdocs$update_user_input(AuthenticationToken = AuthenticationToken, UserId = UserId, GivenName = GivenName, Surname = Surname, Type = Type, StorageRule = StorageRule, TimeZoneId = TimeZoneId, Locale = Locale, GrantPoweruserPrivileges = GrantPoweruserPrivileges)
  output <- .workdocs$update_user_output()
  config <- get_config()
  svc <- .workdocs$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workdocs$operations$update_user <- workdocs_update_user
