% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces_operations.R
\name{workspaces_describe_workspaces_connection_status}
\alias{workspaces_describe_workspaces_connection_status}
\title{Describes the connection status of the specified WorkSpaces}
\usage{
workspaces_describe_workspaces_connection_status(WorkspaceIds,
  NextToken)
}
\arguments{
\item{WorkspaceIds}{The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.}

\item{NextToken}{If you received a \code{NextToken} from a previous call that was paginated,
provide this token to receive the next set of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  WorkspacesConnectionStatus = list(
    list(
      WorkspaceId = "string",
      ConnectionState = "CONNECTED"|"DISCONNECTED"|"UNKNOWN",
      ConnectionStateCheckTimestamp = as.POSIXct(
        "2015-01-01"
      ),
      LastKnownUserConnectionTimestamp = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Describes the connection status of the specified WorkSpaces.
}
\section{Request syntax}{
\preformatted{svc$describe_workspaces_connection_status(
  WorkspaceIds = list(
    "string"
  ),
  NextToken = "string"
)
}
}

\keyword{internal}
